/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vethea;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vethea.EntityInsectFourteen;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelInsectFourteen
extends EntityModel<EntityInsectFourteen> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("insect_fourteen");
    private final ModelPart LegPair2;
    private final ModelPart LegPair1;
    private final ModelPart Head;
    private final ModelPart LeftArm;
    private final ModelPart RightArm;
    private final ModelPart Body;

    public ModelInsectFourteen(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.LegPair2 = root.getChild("LegPair2");
        this.LegPair1 = root.getChild("LegPair1");
        this.Head = root.getChild("Head");
        this.LeftArm = root.getChild("LeftArm");
        this.RightArm = root.getChild("RightArm");
        this.Body = root.getChild("Body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation zero = new CubeDeformation(0.0f);
        partdefinition.addOrReplaceChild("LegPair2", CubeListBuilder.create().texOffs(34, 25).addBox(0.5f, 0.0f, -2.0f, 4.0f, 9.0f, 4.0f, zero).texOffs(34, 25).addBox(-9.25f, 0.0f, -2.0f, 4.0f, 9.0f, 4.0f, zero), PartPose.offset((float)0.0f, (float)15.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("LegPair1", CubeListBuilder.create().texOffs(34, 25).addBox(5.5f, 0.0f, -3.0f, 4.0f, 9.0f, 4.0f, zero).texOffs(34, 25).addBox(-4.5f, 0.0f, -3.0f, 4.0f, 9.0f, 4.0f, zero), PartPose.offset((float)0.0f, (float)15.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 0).addBox(-6.5f, -12.5f, -6.0f, 13.0f, 13.0f, 12.0f, zero).texOffs(0, 25).addBox(-8.5f, -13.5f, -1.0f, 17.0f, 2.0f, 2.0f, zero).texOffs(0, 0).addBox(-8.5f, -19.5f, -1.0f, 2.0f, 6.0f, 2.0f, zero).texOffs(0, 0).addBox(-5.5f, -19.5f, -1.0f, 2.0f, 6.0f, 2.0f, zero).texOffs(0, 0).addBox(0.5f, -19.5f, -1.0f, 2.0f, 6.0f, 2.0f, zero).texOffs(0, 0).addBox(6.5f, -19.5f, -1.0f, 2.0f, 6.0f, 2.0f, zero).texOffs(0, 0).addBox(3.5f, -19.5f, -1.0f, 2.0f, 6.0f, 2.0f, zero).texOffs(0, 0).addBox(-2.5f, -19.5f, -1.0f, 2.0f, 6.0f, 2.0f, zero), PartPose.offset((float)0.0f, (float)9.5f, (float)0.0f));
        partdefinition.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(38, 0).addBox(-2.0f, -9.0f, -1.5f, 3.0f, 9.0f, 3.0f, zero), PartPose.offset((float)9.75f, (float)11.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(38, 0).addBox(-1.0f, -9.0f, -1.5f, 3.0f, 9.0f, 3.0f, zero), PartPose.offset((float)-9.75f, (float)11.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 29).addBox(-10.0f, -15.0f, -3.0f, 20.0f, 6.0f, 6.0f, zero), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)52, (int)41);
    }

    public void setupAnim(EntityInsectFourteen entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.Head.xRot = headPitch * ((float)Math.PI / 180);
        this.LegPair1.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.LegPair2.xRot = -Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        if (entity.isAggressive()) {
            this.LeftArm.xRot = 0.0f;
            this.RightArm.xRot = 0.0f;
        } else {
            this.RightArm.xRot = -Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
            this.LeftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.LegPair2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.LegPair1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.LeftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.RightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

