/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vanilla.nether.EntityWildfire;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class ModelWildfire
extends EntityModel<EntityWildfire> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("wildfire");
    private final ModelPart body;
    private final ModelPart leftarm;
    private final ModelPart rightleg;
    private final ModelPart leftleg;
    public final ModelPart rightarm;

    public ModelWildfire(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.body = root.getChild("body");
        this.leftarm = root.getChild("leftarm");
        this.rightleg = root.getChild("rightleg");
        this.leftleg = root.getChild("leftleg");
        this.rightarm = root.getChild("rightarm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(43, 18).mirror().addBox(1.0f, 0.0f, -2.0f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(16, 16).mirror().addBox(-9.0f, 0.0f, -2.0f, 5.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(40, 16).mirror().addBox(-10.0f, -4.0f, -3.0f, 2.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(43, 18).mirror().addBox(-10.0f, 0.0f, -2.0f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(40, 16).mirror().addBox(0.0f, -4.0f, -3.0f, 2.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(16, 16).mirror().addBox(-4.0f, 0.0f, -2.0f, 5.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)4.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("P11_r1", CubeListBuilder.create().texOffs(32, 0).mirror().addBox(-3.0f, 0.0f, -6.0f, 6.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-4.0f, (float)-7.0f, (float)2.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("P12_r1", CubeListBuilder.create().texOffs(32, 17).mirror().addBox(-4.0f, -11.0f, 5.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(32, 17).mirror().addBox(2.0f, -11.0f, 5.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-4.0f, (float)-4.0f, (float)3.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("P13_r1", CubeListBuilder.create().texOffs(19, 22).mirror().addBox(1.0f, -9.0f, 0.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(19, 22).mirror().addBox(-5.0f, -9.0f, 0.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-4.0f, (float)-4.0f, (float)0.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("P16_r1", CubeListBuilder.create().texOffs(32, 17).mirror().addBox(-1.0f, -8.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(32, 17).mirror().addBox(-7.0f, -8.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.0f, (float)-3.0f, (float)1.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition leftarm = partdefinition.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(-2.0f, -4.0f, -2.0f, 6.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(40, 16).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)7.0f, (float)2.0f, (float)0.0f));
        leftarm.addOrReplaceChild("P10_r1", CubeListBuilder.create().texOffs(23, 19).mirror().addBox(0.0f, -3.0f, -1.0f, 3.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)4.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-2.5307f));
        partdefinition.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-3.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)3.0f, (float)12.0f, (float)0.0f));
        PartDefinition rightarm = partdefinition.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(-4.0f, -4.0f, -2.0f, 6.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(40, 16).mirror().addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-7.0f, (float)2.0f, (float)0.0f));
        rightarm.addOrReplaceChild("P9_r1", CubeListBuilder.create().texOffs(23, 19).mirror().addBox(-2.2f, -2.0f, -1.0f, 3.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-3.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)2.5307f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(EntityWildfire entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.rightarm.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * 2.0 * (double)limbSwingAmount * 0.5);
        this.leftarm.xRot = (float)(Math.cos(limbSwing * 0.6662f) * 2.0 * (double)limbSwingAmount * 0.5);
        this.rightleg.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
        this.leftleg.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
        this.rightleg.yRot = 0.0f;
        this.leftleg.yRot = 0.0f;
        this.rightarm.yRot = 0.0f;
        this.leftarm.yRot = 0.0f;
        this.rightarm.zRot = (float)(Math.cos(ageInTicks * 0.09f) * (double)0.05f + (double)0.05f);
        this.leftarm.zRot = (float)(-Math.cos(ageInTicks * 0.09f) * (double)0.05f + (double)0.05f);
        this.rightarm.xRot = (float)((double)this.rightarm.xRot + Math.sin(ageInTicks * 0.067f) * (double)0.05f);
        this.leftarm.xRot = (float)((double)this.leftarm.xRot - Math.sin(ageInTicks * 0.067f) * (double)0.05f);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

