/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.base.EntityDivineTameable;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class ModelSnapper<T extends EntityDivineTameable>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("snapper");
    private final ModelPart Head;
    private final ModelPart FrontRightLeg;
    private final ModelPart FrontLeftLeg;
    private final ModelPart BackLeftLeg;
    private final ModelPart BackRightLeg;
    private final ModelPart Body;

    public ModelSnapper(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Head = root.getChild("Head");
        this.FrontRightLeg = root.getChild("FrontRightLeg");
        this.FrontLeftLeg = root.getChild("FrontLeftLeg");
        this.BackLeftLeg = root.getChild("BackLeftLeg");
        this.BackRightLeg = root.getChild("BackRightLeg");
        this.Body = root.getChild("Body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(43, 43).addBox(-4.0f, -2.5f, -6.0f, 8.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-7.0f));
        partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 0).addBox(-11.0f, -1.0f, -3.0f, 22.0f, 0.0f, 21.0f, new CubeDeformation(0.0f)).texOffs(0, 21).addBox(-9.0f, -5.0f, -1.0f, 18.0f, 5.0f, 17.0f, new CubeDeformation(0.0f)).texOffs(0, 43).addBox(-7.0f, 0.0f, 0.0f, 14.0f, 5.0f, 15.0f, new CubeDeformation(0.0f)).texOffs(0, 64).addBox(-5.0f, -1.0f, -0.01f, 10.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-7.0f));
        partdefinition.addOrReplaceChild("FrontLeftLeg", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)0.0f, (float)-4.0f));
        partdefinition.addOrReplaceChild("BackLeftLeg", CubeListBuilder.create().texOffs(0, 8).addBox(-1.5f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)0.0f, (float)4.0f));
        partdefinition.addOrReplaceChild("FrontRightLeg", CubeListBuilder.create().texOffs(0, 24).addBox(-2.5f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)0.0f, (float)-4.0f));
        partdefinition.addOrReplaceChild("BackRightLeg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.5f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)0.0f, (float)4.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.isInSittingPose()) {
            this.Head.y = 21.0f;
            this.Body.y = 19.0f;
            this.FrontLeftLeg.y = 22.49f;
            this.FrontRightLeg.y = 22.49f;
            this.BackLeftLeg.y = 22.49f;
            this.BackRightLeg.y = 22.49f;
            this.FrontLeftLeg.xRot = 0.0f;
            this.FrontRightLeg.xRot = 0.0f;
            this.BackLeftLeg.xRot = 0.0f;
            this.BackRightLeg.xRot = 0.0f;
            this.BackRightLeg.zRot = 1.5707964f;
            this.BackLeftLeg.zRot = -1.5707964f;
            this.FrontRightLeg.zRot = this.BackRightLeg.zRot;
            this.FrontLeftLeg.zRot = this.BackLeftLeg.zRot;
        } else {
            this.Head.y = 18.0f;
            this.Body.y = 16.0f;
            this.FrontLeftLeg.y = 20.0f;
            this.FrontRightLeg.y = 20.0f;
            this.BackLeftLeg.y = 20.0f;
            this.BackRightLeg.y = 20.0f;
            this.BackRightLeg.zRot = 0.0f;
            this.BackLeftLeg.zRot = 0.0f;
            this.FrontRightLeg.zRot = this.BackRightLeg.zRot;
            this.FrontLeftLeg.zRot = this.BackLeftLeg.zRot;
            this.FrontLeftLeg.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
            this.FrontRightLeg.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
            this.BackLeftLeg.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
            this.BackRightLeg.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
        }
        this.Head.yRot = netHeadYaw / 114.59155f;
        this.Head.xRot = headPitch / 114.59155f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.FrontRightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.FrontLeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.BackLeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.BackRightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

