/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vanilla.overworld.EntitySaguaroWorm;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class ModelSaguaroWorm
extends EntityModel<EntitySaguaroWorm> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("saguaro_worm");
    public final ModelPart base;
    public final ModelPart active;
    public final ModelPart inactive;

    public ModelSaguaroWorm(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.base = root.getChild("base");
        this.active = root.getChild("active");
        this.inactive = root.getChild("inactive");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        partdefinition.addOrReplaceChild("base", CubeListBuilder.create().texOffs(0, 30).addBox(1.0f, 0.0f, 1.0f, 14.0f, 16.0f, 14.0f, cubeDef), PartPose.offset((float)-8.0f, (float)8.0f, (float)-8.0f));
        PartDefinition base = partdefinition.addOrReplaceChild("active", CubeListBuilder.create(), PartPose.ZERO);
        base.addOrReplaceChild("connector_bottom", CubeListBuilder.create().texOffs(56, 0).addBox(1.0f, -2.0f, 1.0f, 10.0f, 16.0f, 10.0f, cubeDef), PartPose.offsetAndRotation((float)-6.0f, (float)-1.0f, (float)-9.0f, (float)0.288f, (float)0.0f, (float)0.0f));
        base.addOrReplaceChild("middle_active", CubeListBuilder.create().texOffs(0, 30).addBox(1.0f, 0.0f, 0.0f, 14.0f, 16.0f, 14.0f, cubeDef), PartPose.offsetAndRotation((float)-8.0f, (float)-13.0f, (float)-16.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        base.addOrReplaceChild("connector_top", CubeListBuilder.create().texOffs(56, 0).addBox(1.0f, 0.0f, 1.0f, 10.0f, 16.0f, 10.0f, cubeDef), PartPose.offsetAndRotation((float)-6.0f, (float)-24.0f, (float)-22.0f, (float)0.576f, (float)0.0f, (float)0.0f));
        base.addOrReplaceChild("head_active", CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, -42.5f, -14.0f, 14.0f, 16.0f, 14.0f, cubeDef), PartPose.offsetAndRotation((float)-8.0f, (float)-17.0f, (float)11.5f, (float)1.0472f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("inactive", CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, -32.0f, 1.0f, 14.0f, 16.0f, 14.0f, cubeDef).texOffs(0, 30).addBox(1.0f, -16.0f, 1.0f, 14.0f, 16.0f, 14.0f, cubeDef), PartPose.offset((float)-8.0f, (float)8.0f, (float)-8.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)96, (int)60);
    }

    public void prepareMobModel(EntitySaguaroWorm entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        this.active.visible = entity.getProvoked();
        this.inactive.visible = !this.active.visible;
    }

    public void setupAnim(EntitySaguaroWorm entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.base.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.active.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.inactive.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

