/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vanilla.overworld.EntityRotatick;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelRotatick
extends EntityModel<EntityRotatick> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("rotatick");
    public final ModelPart Body;
    public final ModelPart Head;
    public final ModelPart FrontRightLeg;
    public final ModelPart FrontLeftLeg;
    public final ModelPart MiddleRightLeg;
    public final ModelPart MiddleLeftLeg;
    public final ModelPart BackRightLeg;
    public final ModelPart BackLeftLeg;

    public ModelRotatick(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Body = root.getChild("Body");
        this.Head = this.Body.getChild("Head");
        this.FrontRightLeg = this.Body.getChild("FrontRightLeg");
        this.FrontLeftLeg = this.Body.getChild("FrontLeftLeg");
        this.MiddleRightLeg = this.Body.getChild("MiddleRightLeg");
        this.MiddleLeftLeg = this.Body.getChild("MiddleLeftLeg");
        this.BackRightLeg = this.Body.getChild("BackRightLeg");
        this.BackLeftLeg = this.Body.getChild("BackLeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 0).addBox(-7.0f, -4.0f, -7.0f, 14.0f, 4.0f, 14.0f, cubeDef).texOffs(0, 18).addBox(-6.0f, 0.0f, -7.0f, 12.0f, 4.0f, 14.0f, cubeDef), PartPose.offset((float)0.0f, (float)16.0f, (float)2.0f));
        PartDefinition Head = Body.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(38, 38).addBox(-5.0f, -2.0f, -6.0f, 10.0f, 5.0f, 6.0f, cubeDef).texOffs(0, 36).addBox(-6.0f, -5.0f, -7.0f, 12.0f, 4.0f, 7.0f, cubeDef).texOffs(38, 25).addBox(-3.0f, -1.0f, -7.0f, 6.0f, 4.0f, 1.0f, cubeDef), PartPose.offset((float)0.0f, (float)0.0f, (float)-6.99f));
        Head.addOrReplaceChild("RightMandible", CubeListBuilder.create().texOffs(42, 7).addBox(-0.5f, -1.5f, -3.0f, 1.0f, 3.0f, 4.0f, cubeDef), PartPose.offset((float)-5.5f, (float)2.5f, (float)-5.0f));
        Head.addOrReplaceChild("LeftMandible", CubeListBuilder.create().texOffs(42, 0).addBox(-1.0f, -1.0f, -3.0f, 1.0f, 3.0f, 4.0f, cubeDef), PartPose.offset((float)6.0f, (float)2.0f, (float)-5.0f));
        Body.addOrReplaceChild("FrontRightLeg", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f, cubeDef), PartPose.offset((float)-5.5f, (float)3.99f, (float)-3.5f));
        Body.addOrReplaceChild("FrontLeftLeg", CubeListBuilder.create().texOffs(38, 18).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f, cubeDef), PartPose.offset((float)5.5f, (float)3.99f, (float)-3.5f));
        Body.addOrReplaceChild("MiddleRightLeg", CubeListBuilder.create().texOffs(0, 7).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f, cubeDef), PartPose.offset((float)-5.5f, (float)3.99f, (float)0.5f));
        Body.addOrReplaceChild("MiddleLeftLeg", CubeListBuilder.create().texOffs(31, 36).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f, cubeDef), PartPose.offset((float)5.5f, (float)3.99f, (float)0.5f));
        Body.addOrReplaceChild("BackRightLeg", CubeListBuilder.create().texOffs(0, 18).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f, cubeDef), PartPose.offset((float)-5.5f, (float)3.99f, (float)4.5f));
        Body.addOrReplaceChild("BackLeftLeg", CubeListBuilder.create().texOffs(0, 25).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f, cubeDef), PartPose.offset((float)5.5f, (float)3.99f, (float)4.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(EntityRotatick entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.yRot = netHeadYaw * ((float)Math.PI / 180) / 2.0f;
        this.Head.xRot = headPitch * ((float)Math.PI / 180) / 2.0f;
        float f = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        float f1 = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.Body.zRot = f * 0.03f;
        this.MiddleRightLeg.xRot = this.BackRightLeg.xRot = f;
        this.FrontLeftLeg.xRot = this.BackRightLeg.xRot;
        this.BackLeftLeg.xRot = this.MiddleLeftLeg.xRot = f1;
        this.FrontRightLeg.xRot = this.MiddleLeftLeg.xRot;
        this.BackRightLeg.yRot = 0.3f;
        this.MiddleRightLeg.yRot = 0.2f;
        this.FrontRightLeg.yRot = 0.1f;
        this.BackLeftLeg.yRot = -0.3f;
        this.MiddleLeftLeg.yRot = -0.2f;
        this.FrontLeftLeg.yRot = -0.1f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.Body.render(poseStack, buffer, packedLight, packedOverlay, color);
    }
}

