/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vanilla.overworld.EntityKobblin;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Pose;

public class ModelKobblin
extends EntityModel<EntityKobblin> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("kobblin");
    public final ModelPart Body;
    public final ModelPart Head;
    public final ModelPart RightEar;
    public final ModelPart LeftEar;
    public final ModelPart Tongue;
    public final ModelPart GrassOverlay;
    public final ModelPart RightArm;
    public final ModelPart LeftArm;
    public final ModelPart RightLeg;
    public final ModelPart LeftLeg;
    int tempBiomeColor = 65280;

    public ModelKobblin(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Body = root.getChild("Body");
        this.Head = root.getChild("Head");
        this.RightEar = this.Head.getChild("RightEar");
        this.LeftEar = this.Head.getChild("LeftEar");
        this.Tongue = this.Head.getChild("Tongue");
        this.GrassOverlay = root.getChild("GrassOverlay");
        this.RightArm = this.Body.getChild("RightArm");
        this.LeftArm = this.Body.getChild("LeftArm");
        this.RightLeg = this.Body.getChild("RightLeg");
        this.LeftLeg = this.Body.getChild("LeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(22, 18).addBox(-3.5f, -7.0f, -1.0f, 7.0f, 4.0f, 4.0f, cubeDef).texOffs(22, 26).addBox(-3.0f, -4.0f, -2.0f, 6.0f, 4.0f, 4.0f, cubeDef), PartPose.offset((float)0.0f, (float)22.0f, (float)1.0f));
        PartDefinition Head = partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 18).addBox(-3.0f, -4.0f, -3.0f, 6.0f, 4.0f, 5.0f, cubeDef).texOffs(0, 0).addBox(-7.0f, -6.0f, -8.0f, 14.0f, 2.0f, 14.0f, cubeDef), PartPose.offset((float)0.0f, (float)15.0f, (float)1.0f));
        PartDefinition RightEar = Head.addOrReplaceChild("RightEar", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)-4.0f, (float)0.0f));
        RightEar.addOrReplaceChild("rightear_r1", CubeListBuilder.create().texOffs(8, 37).addBox(-1.0f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, cubeDef), PartPose.rotation((float)0.0f, (float)0.0f, (float)0.21816617f));
        PartDefinition LeftEar = Head.addOrReplaceChild("LeftEar", CubeListBuilder.create(), PartPose.offset((float)3.0f, (float)-4.0f, (float)0.0f));
        LeftEar.addOrReplaceChild("leftear_r1", CubeListBuilder.create().texOffs(14, 37).addBox(0.0f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, cubeDef), PartPose.rotation((float)0.0f, (float)0.0f, (float)-0.21816617f));
        PartDefinition Tongue = Head.addOrReplaceChild("Tongue", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-2.0f, (float)-3.0f));
        Tongue.addOrReplaceChild("tongue_r1", CubeListBuilder.create().texOffs(20, 37).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 3.0f, 0.0f, cubeDef), PartPose.rotation((float)-0.08726647f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("GrassOverlay", CubeListBuilder.create().texOffs(0, 43).addBox(-8.0f, -6.5f, -9.0f, 16.0f, 4.0f, 16.0f, cubeDef), PartPose.offset((float)0.0f, (float)15.0f, (float)1.0f));
        PartDefinition RightArm = Body.addOrReplaceChild("RightArm", CubeListBuilder.create(), PartPose.offset((float)-3.5f, (float)-6.0f, (float)0.99f));
        RightArm.addOrReplaceChild("rightarm_r1", CubeListBuilder.create().texOffs(10, 27).addBox(-2.0f, -1.0f, -2.0f, 2.0f, 7.0f, 3.0f, cubeDef), PartPose.rotation((float)0.0f, (float)0.0f, (float)0.1308997f));
        PartDefinition LeftArm = Body.addOrReplaceChild("LeftArm", CubeListBuilder.create(), PartPose.offset((float)3.5f, (float)-6.0f, (float)0.99f));
        LeftArm.addOrReplaceChild("leftarm_r1", CubeListBuilder.create().texOffs(0, 27).addBox(0.0f, -1.0f, -2.0f, 2.0f, 7.0f, 3.0f, cubeDef), PartPose.rotation((float)0.0f, (float)0.0f, (float)-0.1308997f));
        Body.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(34, 34).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, cubeDef), PartPose.offset((float)-2.0f, (float)0.0f, (float)0.0f));
        Body.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(0, 37).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, cubeDef), PartPose.offset((float)2.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void prepareMobModel(EntityKobblin entity, float limbSwing, float limbSwingAmount, float partialTick) {
        this.tempBiomeColor = entity.clientBiomeColor;
    }

    public void setupAnim(EntityKobblin entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.hasPose(Pose.EMERGING)) {
            float f;
            this.GrassOverlay.xRot = this.Body.xRot = (f = Mth.sin((float)(ageInTicks * (float)Math.PI / 20.0f)));
            this.Head.xRot = this.Body.xRot;
            this.LeftArm.xRot = this.RightArm.xRot = -f;
            this.RightLeg.xRot = this.RightArm.xRot;
            this.LeftLeg.xRot = this.RightArm.xRot;
        } else if (entity.hasPose(Pose.SHOOTING)) {
            float f;
            this.GrassOverlay.zRot = this.Body.zRot = (f = Mth.sin((float)(ageInTicks * (float)Math.PI / 10.0f)) * 0.2f);
            this.Head.zRot = this.Body.zRot;
            this.LeftLeg.zRot = this.RightLeg.zRot = -f;
            this.RightArm.xRot += (float)Math.PI;
        } else {
            float f = Mth.cos((float)limbSwing) * limbSwingAmount;
            float fs = f * 0.1f;
            float f1 = Mth.sin((float)limbSwing) * limbSwingAmount;
            float f1s = f1 * 0.1f;
            this.GrassOverlay.yRot = this.Head.yRot = netHeadYaw * ((float)Math.PI / 180) / 2.0f + fs;
            this.GrassOverlay.xRot = this.Head.xRot = headPitch * ((float)Math.PI / 180) / 2.0f + f1s;
            this.Body.xRot = 0.0f;
            this.Tongue.xRot = this.Body.zRot = fs;
            this.LeftEar.zRot = f1s;
            this.RightEar.zRot = -f1s;
            this.LeftArm.xRot = this.RightLeg.xRot = f;
            this.RightArm.xRot = -f;
            this.LeftLeg.xRot = f1;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.GrassOverlay.render(poseStack, vertexConsumer, packedLight, packedOverlay, this.tempBiomeColor);
    }
}

