/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vanilla.overworld.EntityKingCrab;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class ModelKingCrab
extends EntityModel<EntityKingCrab> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("king_crab");
    private final ModelPart Body;
    private final ModelPart LeftClaw;
    private final ModelPart RightClaw;
    private final ModelPart FrontRightLeg;
    private final ModelPart BackRightLeg;
    private final ModelPart MiddleRightLeg;
    private final ModelPart MiddleLeftLeg;
    private final ModelPart FrontLeftLeg;
    private final ModelPart BackLeftLeg;

    public ModelKingCrab(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Body = root.getChild("Body");
        this.LeftClaw = root.getChild("LeftClaw");
        this.RightClaw = root.getChild("RightClaw");
        this.FrontRightLeg = this.Body.getChild("FrontRightLeg");
        this.BackRightLeg = this.Body.getChild("BackRightLeg");
        this.MiddleRightLeg = this.Body.getChild("MiddleRightLeg");
        this.MiddleLeftLeg = this.Body.getChild("MiddleLeftLeg");
        this.FrontLeftLeg = this.Body.getChild("FrontLeftLeg");
        this.BackLeftLeg = this.Body.getChild("BackLeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 64).addBox(-8.0f, -7.0f, -9.6667f, 16.0f, 2.0f, 20.0f, new CubeDeformation(0.0f)).texOffs(0, 36).addBox(-11.0f, -7.0f, -12.6667f, 22.0f, 2.0f, 26.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-11.0f, -5.0f, -12.6667f, 22.0f, 10.0f, 26.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)10.0f, (float)4.6667f));
        PartDefinition FrontRightLeg = Body.addOrReplaceChild("FrontRightLeg", CubeListBuilder.create(), PartPose.offset((float)-12.0f, (float)1.0f, (float)-4.6667f));
        FrontRightLeg.addOrReplaceChild("FrontRightLeg_r1", CubeListBuilder.create().texOffs(16, 86).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition FrontLeftLeg = Body.addOrReplaceChild("FrontLeftLeg", CubeListBuilder.create(), PartPose.offset((float)12.0f, (float)1.0f, (float)-4.6667f));
        FrontLeftLeg.addOrReplaceChild("FrontLeftLeg_r1", CubeListBuilder.create().texOffs(0, 86).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition MiddleRightLeg = Body.addOrReplaceChild("MiddleRightLeg", CubeListBuilder.create(), PartPose.offset((float)-12.0f, (float)1.0f, (float)2.3333f));
        MiddleRightLeg.addOrReplaceChild("MiddleRightLeg_r1", CubeListBuilder.create().texOffs(16, 86).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition MiddleLeftLeg = Body.addOrReplaceChild("MiddleLeftLeg", CubeListBuilder.create(), PartPose.offset((float)12.0f, (float)1.0f, (float)2.3333f));
        MiddleLeftLeg.addOrReplaceChild("MiddleLeftLeg_r1", CubeListBuilder.create().texOffs(0, 86).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition BackLeftLeg = Body.addOrReplaceChild("BackLeftLeg", CubeListBuilder.create(), PartPose.offset((float)12.0f, (float)1.0f, (float)9.3333f));
        BackLeftLeg.addOrReplaceChild("BackLeftLeg_r1", CubeListBuilder.create().texOffs(0, 86).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition BackRightLeg = Body.addOrReplaceChild("BackRightLeg", CubeListBuilder.create(), PartPose.offset((float)-12.0f, (float)1.0f, (float)9.3333f));
        BackRightLeg.addOrReplaceChild("BackRightLeg_r1", CubeListBuilder.create().texOffs(16, 86).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        partdefinition.addOrReplaceChild("LeftClaw", CubeListBuilder.create().texOffs(77, 64).addBox(0.0f, -3.25f, -10.0f, 6.0f, 1.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(70, 36).addBox(0.0f, -2.25f, -10.0f, 6.0f, 10.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)11.0f, (float)8.25f, (float)-6.0f));
        partdefinition.addOrReplaceChild("RightClaw", CubeListBuilder.create().texOffs(52, 64).addBox(-6.0f, -3.75f, -11.5f, 6.0f, 1.0f, 13.0f, new CubeDeformation(0.0f)).texOffs(70, 0).addBox(-6.0f, -2.75f, -11.5f, 6.0f, 12.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-11.0f, (float)7.75f, (float)-5.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(EntityKingCrab entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.FrontRightLeg.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
        this.BackRightLeg.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.E) * (double)1.4f * (double)limbSwingAmount);
        this.MiddleRightLeg.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.E) * (double)1.4f * (double)limbSwingAmount);
        this.MiddleLeftLeg.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
        this.FrontLeftLeg.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.E) * (double)1.4f * (double)limbSwingAmount);
        this.BackLeftLeg.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.LeftClaw.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.RightClaw.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

