/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;

public class ModelJungleDramcryx<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("jungle_dramcryx");
    private final ModelPart Head;
    private final ModelPart FrontRightLeg;
    private final ModelPart FrontLeftLeg;
    private final ModelPart BackLeftLeg;
    private final ModelPart BackRightLeg;
    private final ModelPart Body;

    public ModelJungleDramcryx(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Head = root.getChild("Head");
        this.FrontRightLeg = root.getChild("FrontRightLeg");
        this.FrontLeftLeg = root.getChild("FrontLeftLeg");
        this.BackLeftLeg = root.getChild("BackLeftLeg");
        this.BackRightLeg = root.getChild("BackRightLeg");
        this.Body = root.getChild("Body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("FrontRightLeg", CubeListBuilder.create().texOffs(28, 0).addBox(-1.5f, -1.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.51f, (float)17.0f, (float)-1.5f));
        partdefinition.addOrReplaceChild("FrontLeftLeg", CubeListBuilder.create().texOffs(12, 27).addBox(-1.5f, -1.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.51f, (float)17.0f, (float)-1.5f));
        partdefinition.addOrReplaceChild("BackLeftLeg", CubeListBuilder.create().texOffs(0, 27).addBox(-1.5f, -1.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.5f, (float)17.0f, (float)5.5f));
        partdefinition.addOrReplaceChild("BackRightLeg", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -1.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.5f, (float)17.0f, (float)5.5f));
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)17.0f, (float)2.5f));
        Body.addOrReplaceChild("Tail_r1", CubeListBuilder.create().texOffs(0, 51).addBox(-2.0f, -6.0f, 0.0f, 4.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)5.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        Body.addOrReplaceChild("Torso_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -3.0f, -10.0f, 8.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)3.5f, (float)-0.2963f, (float)0.0f, (float)0.0f));
        PartDefinition Head = partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(24, 25).addBox(-3.0f, -3.0f, -6.0f, 6.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(22, 16).addBox(3.0f, -1.0f, -6.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 16).addBox(-4.0f, -1.0f, -6.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 16).addBox(-4.5f, -4.0f, -4.0f, 9.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)15.0f, (float)-3.0f));
        Head.addOrReplaceChild("RightEar", CubeListBuilder.create().texOffs(37, 30).addBox(-1.0f, -2.5f, -1.5f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-4.0f, (float)-3.0f));
        Head.addOrReplaceChild("LeftEar", CubeListBuilder.create().texOffs(37, 13).addBox(-1.0f, -2.5f, -1.5f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-4.0f, (float)-3.0f));
        PartDefinition Spines = Body.addOrReplaceChild("Spines", CubeListBuilder.create(), PartPose.offset((float)0.5f, (float)-1.0f, (float)2.5f));
        Spines.addOrReplaceChild("BackSpine_r1", CubeListBuilder.create().texOffs(0, 38).addBox(-1.0f, -4.0f, -1.0f, 1.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.1345f, (float)0.0f, (float)0.0f));
        Spines.addOrReplaceChild("MiddleSpine_r1", CubeListBuilder.create().texOffs(28, 33).addBox(-1.0f, -6.0f, -1.5f, 2.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-1.0f, (float)-2.5f, (float)-0.829f, (float)0.0f, (float)0.0f));
        Spines.addOrReplaceChild("FrontSpine_r1", CubeListBuilder.create().texOffs(26, 16).addBox(-1.5f, -5.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-3.0f, (float)-4.5f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.yRot = netHeadYaw / 57.295776f;
        this.Head.xRot = headPitch / 57.295776f;
        this.FrontLeftLeg.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
        this.FrontRightLeg.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
        this.BackLeftLeg.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
        this.BackRightLeg.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.FrontRightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.FrontLeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.BackLeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.BackRightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

