/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.base.EntityDivineTameable;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelGrizzle<T extends EntityDivineTameable>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("grizzle");
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart leg4;
    private final ModelPart leg3;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart tail;

    public ModelGrizzle(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.leg1 = root.getChild("leg1");
        this.leg2 = root.getChild("leg2");
        this.leg4 = root.getChild("leg4");
        this.leg3 = root.getChild("leg3");
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.tail = root.getChild("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-1.9999f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.0f, (float)14.0f, (float)-8.0f));
        partdefinition.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-1.9999f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.0f, (float)16.0f, (float)8.0f));
        partdefinition.addOrReplaceChild("leg4", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-2.0001f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)4.0f, (float)16.0f, (float)8.0f));
        partdefinition.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-2.0001f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)4.0f, (float)14.0f, (float)-8.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(0.0f, 0.0f, 0.0f, 12.0f, 10.0f, 22.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-6.0f, (float)4.5f, (float)-11.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 32).mirror().addBox(-4.0f, -3.0f, -5.0f, 8.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 46).mirror().addBox(-2.0f, 1.0f, -9.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 14).mirror().addBox(3.0f, -4.0f, -1.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 14).mirror().addBox(-5.0f, -4.0f, -1.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)5.0f, (float)-11.0f));
        partdefinition.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 26).mirror().addBox(5.0f, 4.0f, 21.54f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-6.0f, (float)4.5f, (float)-11.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        float f = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        float f1 = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leg1.xRot = this.leg2.xRot = f;
        this.leg3.xRot = this.leg4.xRot = f1;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.leg1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leg2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leg4.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leg3.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.tail.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

