/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vanilla.overworld.EntityGlacon;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelGlacon
extends EntityModel<EntityGlacon> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("glacon");
    public final ModelPart Spine;
    public final ModelPart Body;
    public final ModelPart RightSail;
    public final ModelPart LeftSail;
    public final ModelPart RightSmallSail;
    public final ModelPart LeftSmallSail;
    public final ModelPart Head;
    public final ModelPart RightWhisker;
    public final ModelPart LeftWhisker;
    public final ModelPart RightFrontLeg;
    public final ModelPart RightMiddleLeg;
    public final ModelPart RightRearLeg;
    public final ModelPart LeftFrontLeg;
    public final ModelPart LeftMiddleLeg;
    public final ModelPart LeftRearLeg;

    public ModelGlacon(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Spine = root.getChild("Spine");
        this.Body = this.Spine.getChild("Body");
        this.RightSail = this.Body.getChild("RightSail");
        this.LeftSail = this.Body.getChild("LeftSail");
        this.RightSmallSail = this.Body.getChild("RightSmallSail");
        this.LeftSmallSail = this.Body.getChild("LeftSmallSail");
        this.Head = this.Body.getChild("Head");
        this.RightWhisker = this.Head.getChild("RightWhisker");
        this.LeftWhisker = this.Head.getChild("LeftWhisker");
        this.RightFrontLeg = root.getChild("RightLegFront");
        this.RightMiddleLeg = root.getChild("RightLegMiddle");
        this.RightRearLeg = root.getChild("RightLegBack");
        this.LeftFrontLeg = root.getChild("LeftLegFront");
        this.LeftMiddleLeg = root.getChild("LeftLegMiddle");
        this.LeftRearLeg = root.getChild("LeftLegBack");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartDefinition Spine = partdefinition.addOrReplaceChild("Spine", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)12.0f, (float)-1.0f));
        PartDefinition Body = Spine.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 29).addBox(-6.0f, -8.0f, -8.0f, 12.0f, 9.0f, 8.0f, cubeDef).texOffs(0, 73).addBox(-2.0f, 1.0f, -8.0f, 4.0f, 7.0f, 2.0f, cubeDef), PartPose.offset((float)0.0f, (float)0.0f, (float)-3.0f));
        Body.addOrReplaceChild("RightSmallSail", CubeListBuilder.create().texOffs(38, 0).addBox(0.0f, -8.0f, -1.0f, 0.0f, 8.0f, 14.0f, cubeDef).texOffs(68, 0).addBox(-0.01f, -8.0f, -1.0f, 0.0f, 8.0f, 14.0f, cubeDef), PartPose.offset((float)-2.0f, (float)-8.0f, (float)-3.0f));
        Body.addOrReplaceChild("LeftSmallSail", CubeListBuilder.create().texOffs(76, 15).addBox(0.0f, -8.0f, -1.0f, 0.0f, 8.0f, 14.0f, cubeDef).texOffs(100, 15).addBox(0.01f, -8.0f, -1.0f, 0.0f, 8.0f, 14.0f, cubeDef), PartPose.offset((float)2.0f, (float)-8.0f, (float)-3.0f));
        Body.addOrReplaceChild("RightSail", CubeListBuilder.create().texOffs(0, 78).addBox(0.0f, -9.0f, -2.0f, 0.0f, 10.0f, 14.0f, cubeDef).texOffs(30, 78).addBox(0.01f, -9.0f, -2.0f, 0.0f, 10.0f, 14.0f, cubeDef), PartPose.offset((float)-6.0f, (float)-9.0f, (float)-6.0f));
        Body.addOrReplaceChild("LeftSail", CubeListBuilder.create().texOffs(0, 68).addBox(0.0f, -9.0f, -2.0f, 0.0f, 10.0f, 14.0f, cubeDef).texOffs(30, 68).addBox(-0.01f, -9.0f, -2.0f, 0.0f, 10.0f, 14.0f, cubeDef), PartPose.offset((float)6.0f, (float)-9.0f, (float)-6.0f));
        PartDefinition Head = Body.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(47, 47).addBox(-3.0f, -3.5f, -8.5f, 6.0f, 7.0f, 9.0f, cubeDef), PartPose.offset((float)0.0f, (float)-5.5f, (float)-8.49f));
        Head.addOrReplaceChild("RightWhisker", CubeListBuilder.create().texOffs(0, 16).addBox(-4.5f, -2.5f, 0.0f, 5.0f, 5.0f, 0.0f, cubeDef).texOffs(38, 0).addBox(-4.5f, -2.5f, -0.01f, 5.0f, 5.0f, 0.0f, cubeDef), PartPose.offset((float)-3.5f, (float)2.0f, (float)-7.5f));
        Head.addOrReplaceChild("LeftWhisker", CubeListBuilder.create().texOffs(10, 16).addBox(-0.5f, -2.5f, 0.0f, 5.0f, 5.0f, 0.0f, cubeDef).texOffs(48, 0).addBox(-0.5f, -2.5f, -0.01f, 5.0f, 5.0f, 0.0f, cubeDef), PartPose.offset((float)3.5f, (float)2.0f, (float)-7.5f));
        Spine.addOrReplaceChild("Hip", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -3.5f, -3.0f, 8.0f, 7.0f, 22.0f, cubeDef), PartPose.offset((float)0.0f, (float)-3.5f, (float)-3.0f));
        partdefinition.addOrReplaceChild("RightLegFront", CubeListBuilder.create().texOffs(60, 22).addBox(-2.0f, -0.5f, -2.0f, 4.0f, 11.0f, 4.0f, cubeDef), PartPose.offset((float)-5.0f, (float)12.49f, (float)-5.0f));
        partdefinition.addOrReplaceChild("RightLegMiddle", CubeListBuilder.create().texOffs(32, 59).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDef), PartPose.offset((float)-4.0f, (float)11.99f, (float)3.0f));
        partdefinition.addOrReplaceChild("RightLegBack", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDef), PartPose.offset((float)-4.0f, (float)11.99f, (float)9.0f));
        partdefinition.addOrReplaceChild("LeftLegFront", CubeListBuilder.create().texOffs(48, 63).addBox(-2.0f, -0.5f, -2.0f, 4.0f, 11.0f, 4.0f, cubeDef), PartPose.offset((float)5.0f, (float)12.49f, (float)-5.0f));
        partdefinition.addOrReplaceChild("LeftLegMiddle", CubeListBuilder.create().texOffs(0, 56).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDef), PartPose.offset((float)4.0f, (float)11.99f, (float)3.0f));
        partdefinition.addOrReplaceChild("LeftLegBack", CubeListBuilder.create().texOffs(16, 56).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDef), PartPose.offset((float)4.0f, (float)11.99f, (float)9.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(EntityGlacon entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.xRot = headPitch * ((float)Math.PI / 180);
        this.Head.yRot = netHeadYaw * ((float)Math.PI / 180);
        float f = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        float f1 = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        float f2 = 0.19634955f + Mth.cos((float)(ageInTicks * 0.05f + limbSwing * 0.2f)) * 0.08f + limbSwingAmount * 0.2f;
        this.Spine.zRot = f * 0.02f;
        this.LeftSail.yRot = this.LeftSmallSail.yRot = f2;
        this.RightWhisker.yRot = this.LeftSmallSail.yRot;
        this.RightSail.yRot = this.RightSmallSail.yRot = -f2;
        this.LeftWhisker.yRot = this.RightSmallSail.yRot;
        this.LeftMiddleLeg.xRot = this.LeftRearLeg.xRot = f1;
        this.RightFrontLeg.xRot = this.LeftRearLeg.xRot;
        this.RightMiddleLeg.xRot = this.RightRearLeg.xRot = f;
        this.LeftFrontLeg.xRot = this.RightRearLeg.xRot;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Spine.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.RightFrontLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.RightMiddleLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.RightRearLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.LeftFrontLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.LeftMiddleLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.LeftRearLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

