/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.base.EntityDivineTameable;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelEhu
extends EntityModel<EntityDivineTameable> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("ehu");
    public final ModelPart body;
    public final ModelPart head;
    public final ModelPart BackRightLeg;
    public final ModelPart BackLeftLeg;
    public final ModelPart FrontRightLeg;
    public final ModelPart FrontLeftLeg;

    public ModelEhu(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.body = root.getChild("body");
        this.head = this.body.getChild("head");
        this.BackRightLeg = root.getChild("BackRightLeg");
        this.BackLeftLeg = root.getChild("BackLeftLeg");
        this.FrontRightLeg = root.getChild("FrontRightLeg");
        this.FrontLeftLeg = root.getChild("FrontLeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 46).addBox(-5.0f, -4.0f, -6.01f, 10.0f, 8.0f, 0.0f, cubeDef).texOffs(0, 25).addBox(0.0f, -7.0f, -6.0f, 0.0f, 3.0f, 9.0f, cubeDef).texOffs(0, 0).addBox(-5.0f, -4.0f, -6.0f, 10.0f, 8.0f, 10.0f, cubeDef), PartPose.ZERO);
        body.addOrReplaceChild("lowerbody", CubeListBuilder.create().texOffs(0, 18).addBox(-5.5f, -5.5f, 0.0f, 11.0f, 9.0f, 7.0f, cubeDef), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(30, 0).addBox(-4.0f, -3.0f, -3.0f, 8.0f, 6.0f, 4.0f, cubeDef).texOffs(0, 0).addBox(-1.0f, -1.0f, -3.5f, 2.0f, 2.0f, 1.0f, cubeDef), PartPose.offset((float)0.0f, (float)0.0f, (float)-5.99f));
        partdefinition.addOrReplaceChild("BackRightLeg", CubeListBuilder.create().texOffs(31, 29).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 7.0f, 5.0f, cubeDef), PartPose.offset((float)-4.0f, (float)0.0f, (float)3.0f));
        partdefinition.addOrReplaceChild("BackLeftLeg", CubeListBuilder.create().texOffs(13, 34).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 7.0f, 5.0f, cubeDef), PartPose.offset((float)4.0f, (float)0.0f, (float)3.0f));
        partdefinition.addOrReplaceChild("FrontRightLeg", CubeListBuilder.create().texOffs(36, 14).addBox(-2.5f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, cubeDef), PartPose.offset((float)-3.0f, (float)0.0f, (float)-3.0f));
        partdefinition.addOrReplaceChild("FrontLeftLeg", CubeListBuilder.create().texOffs(31, 41).addBox(-1.5f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, cubeDef), PartPose.offset((float)3.0f, (float)0.0f, (float)-3.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(EntityDivineTameable entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180) / 2.0f;
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180) / 2.0f;
        float f = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        float f1 = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        if (entity.isInSittingPose()) {
            this.body.y = 19.5f;
            this.body.zRot = 0.0f;
            this.FrontRightLeg.y = 22.5f;
            this.FrontLeftLeg.y = 22.5f;
            this.BackRightLeg.y = 21.99f;
            this.BackLeftLeg.y = 21.99f;
            this.BackRightLeg.xRot = 0.0f;
            this.BackLeftLeg.xRot = 0.0f;
            this.FrontRightLeg.xRot = 0.0f;
            this.FrontLeftLeg.xRot = 0.0f;
            this.FrontRightLeg.zRot = 1.5707964f;
            this.BackRightLeg.zRot = 1.5707964f;
            this.FrontLeftLeg.zRot = -1.5707964f;
            this.BackLeftLeg.zRot = -1.5707964f;
        } else {
            this.body.y = 16.0f;
            this.body.zRot = f * 0.05f;
            this.BackRightLeg.y = 18.0f;
            this.BackLeftLeg.y = 18.0f;
            this.FrontRightLeg.y = 18.0f;
            this.FrontLeftLeg.y = 18.0f;
            this.FrontLeftLeg.zRot = 0.0f;
            this.FrontRightLeg.zRot = 0.0f;
            this.BackLeftLeg.zRot = 0.0f;
            this.BackRightLeg.zRot = 0.0f;
            this.FrontRightLeg.xRot = this.BackLeftLeg.xRot = f1;
            this.FrontLeftLeg.xRot = this.BackRightLeg.xRot = f;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.BackLeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.BackRightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.FrontLeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.FrontRightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

