/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.twilight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelTermid<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("termid");
    private final ModelPart legR;
    private final ModelPart legL;
    private final ModelPart body;
    private final ModelPart ridge1;
    private final ModelPart ridge2;
    private final ModelPart ridge3;
    private final ModelPart ridge4;
    private final ModelPart ridge5;
    private final ModelPart ridge6;
    private final ModelPart ridge7;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart jawL;
    private final ModelPart jawR;

    public ModelTermid(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.legR = root.getChild("legR");
        this.legL = root.getChild("legL");
        this.body = root.getChild("body");
        this.ridge1 = root.getChild("ridge1");
        this.ridge2 = root.getChild("ridge2");
        this.ridge3 = root.getChild("ridge3");
        this.ridge4 = root.getChild("ridge4");
        this.ridge5 = root.getChild("ridge5");
        this.ridge6 = root.getChild("ridge6");
        this.ridge7 = root.getChild("ridge7");
        this.neck = root.getChild("neck");
        this.head = root.getChild("head");
        this.jawL = root.getChild("jawL");
        this.jawR = root.getChild("jawR");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("legR", CubeListBuilder.create().texOffs(0, 19).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-2.5f, (float)20.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("legL", CubeListBuilder.create().texOffs(0, 19).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)2.5f, (float)20.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(0.0f, 0.0f, 0.0f, 6.0f, 15.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-3.0f, (float)5.0f, (float)-2.0f));
        partdefinition.addOrReplaceChild("ridge1", CubeListBuilder.create().texOffs(20, 0).mirror().addBox(0.0f, 0.0f, 0.0f, 8.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.0f, (float)18.0f, (float)-3.0f));
        partdefinition.addOrReplaceChild("ridge2", CubeListBuilder.create().texOffs(20, 0).mirror().addBox(0.0f, 0.0f, 0.0f, 8.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.0f, (float)16.0f, (float)-3.0f));
        partdefinition.addOrReplaceChild("ridge3", CubeListBuilder.create().texOffs(20, 0).mirror().addBox(0.0f, 0.0f, 0.0f, 8.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.0f, (float)14.0f, (float)-3.0f));
        partdefinition.addOrReplaceChild("ridge4", CubeListBuilder.create().texOffs(20, 0).mirror().addBox(0.0f, 0.0f, 0.0f, 8.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.0f, (float)12.0f, (float)-3.0f));
        partdefinition.addOrReplaceChild("ridge5", CubeListBuilder.create().texOffs(20, 0).mirror().addBox(0.0f, 0.0f, 0.0f, 8.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.0f, (float)10.0f, (float)-3.0f));
        partdefinition.addOrReplaceChild("ridge6", CubeListBuilder.create().texOffs(20, 0).mirror().addBox(0.0f, 0.0f, 0.0f, 8.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.0f, (float)8.0f, (float)-3.0f));
        partdefinition.addOrReplaceChild("ridge7", CubeListBuilder.create().texOffs(20, 0).mirror().addBox(0.0f, 0.0f, 0.0f, 8.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.0f, (float)6.0f, (float)-3.0f));
        partdefinition.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(22, 25).mirror().addBox(-1.5f, -6.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)1.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 25).mirror().addBox(-3.0f, -6.0f, -2.5f, 6.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)3.0f, (float)-3.0f));
        partdefinition.addOrReplaceChild("jawL", CubeListBuilder.create().texOffs(0, 36).mirror().addBox(2.0f, -1.0f, -5.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)3.0f, (float)-3.0f));
        partdefinition.addOrReplaceChild("jawR", CubeListBuilder.create().texOffs(0, 36).mirror().addBox(-3.0f, -1.0f, -5.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)3.0f, (float)-3.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.legL.xRot = Mth.cos((float)(limbSwing * 0.6662f + 3.141593f)) * 1.4f * limbSwingAmount;
        this.legR.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.legR.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.legL.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.ridge1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.ridge2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.ridge3.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.ridge4.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.ridge5.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.ridge6.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.ridge7.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.neck.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.jawL.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.jawR.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

