/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.twilight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.mortum.EntitySoulStealer;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelSoulStealer
extends EntityModel<EntitySoulStealer> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("soul_stealer");
    public final ModelPart Body;
    public final ModelPart Head;
    public final ModelPart RightEar;
    public final ModelPart LeftEar;
    public final ModelPart RightArm;
    public final ModelPart LeftArm;
    public final ModelPart RightLeg;
    public final ModelPart LeftLeg;

    public ModelSoulStealer(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Body = root.getChild("Body");
        this.Head = this.Body.getChild("Head");
        this.RightEar = this.Head.getChild("RightEar");
        this.LeftEar = this.Head.getChild("LeftEar");
        this.RightArm = this.Body.getChild("RightArm");
        this.LeftArm = this.Body.getChild("LeftArm");
        this.RightLeg = root.getChild("RightLeg");
        this.LeftLeg = root.getChild("LeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 0).addBox(-11.0f, -18.0f, -4.0f, 22.0f, 18.0f, 11.0f, cubeDef), PartPose.offset((float)0.0f, (float)14.0f, (float)0.0f));
        PartDefinition Head = Body.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 29).addBox(-7.0f, -6.0f, -4.0f, 14.0f, 6.0f, 8.0f, cubeDef), PartPose.offset((float)0.0f, (float)-18.0f, (float)0.0f));
        PartDefinition RightEar = Head.addOrReplaceChild("RightEar", CubeListBuilder.create(), PartPose.offset((float)-6.0f, (float)-4.0f, (float)1.0f));
        RightEar.addOrReplaceChild("rightear_r1", CubeListBuilder.create().texOffs(68, 41).addBox(-10.0f, -10.0f, 0.0f, 10.0f, 12.0f, 0.0f, cubeDef), PartPose.rotation((float)-0.1309f, (float)0.5672f, (float)0.0f));
        PartDefinition LeftEar = Head.addOrReplaceChild("LeftEar", CubeListBuilder.create(), PartPose.offset((float)6.0f, (float)-4.0f, (float)1.0f));
        LeftEar.addOrReplaceChild("leftear_r1", CubeListBuilder.create().texOffs(60, 29).addBox(0.0f, -10.0f, 0.0f, 10.0f, 12.0f, 0.0f, cubeDef), PartPose.rotation((float)-0.1309f, (float)-0.5672f, (float)0.0f));
        Body.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(66, 0).addBox(-5.0f, -1.0f, -3.0f, 5.0f, 16.0f, 6.0f, cubeDef), PartPose.offset((float)-11.0f, (float)-17.0f, (float)0.0f));
        Body.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(0, 61).addBox(0.0f, -1.0f, -3.0f, 5.0f, 16.0f, 6.0f, cubeDef), PartPose.offset((float)11.0f, (float)-17.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(0, 43).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 10.0f, 8.0f, cubeDef), PartPose.offset((float)-7.0f, (float)14.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(36, 35).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 10.0f, 8.0f, cubeDef), PartPose.offset((float)7.0f, (float)14.0f, (float)0.0f));
        Body.addOrReplaceChild("RightRibs", CubeListBuilder.create().texOffs(60, 53).addBox(0.0f, -9.0f, -3.0f, 11.0f, 18.0f, 3.0f, cubeDef), PartPose.offset((float)-11.0f, (float)-9.0f, (float)-4.0f));
        Body.addOrReplaceChild("LeftRibs", CubeListBuilder.create().texOffs(32, 53).addBox(-11.0f, -9.0f, -3.0f, 11.0f, 18.0f, 3.0f, cubeDef), PartPose.offset((float)11.0f, (float)-9.0f, (float)-4.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(EntitySoulStealer entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.Head.xRot = headPitch * ((float)Math.PI / 180);
        this.RightEar.yRot = -0.19634955f - Mth.cos((float)(ageInTicks * 0.1f + limbSwing * 0.6f)) * 0.08f + limbSwingAmount * 0.2f;
        this.LeftEar.yRot = 0.19634955f + Mth.cos((float)(ageInTicks * 0.1f + limbSwing * 0.5f)) * 0.08f + limbSwingAmount * 0.2f;
        this.LeftArm.zRot = 0.0f;
        this.RightArm.zRot = 0.0f;
        this.LeftArm.yRot = 0.0f;
        this.RightArm.yRot = 0.0f;
        AnimationUtils.bobModelPart((ModelPart)this.RightArm, (float)ageInTicks, (float)1.0f);
        AnimationUtils.bobModelPart((ModelPart)this.LeftArm, (float)ageInTicks, (float)-1.0f);
        float f = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        float f1 = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.Body.zRot = f * 0.1f;
        this.RightLeg.xRot = f;
        this.LeftLeg.xRot = f1;
    }

    public void prepareMobModel(EntitySoulStealer entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        super.prepareMobModel((Entity)entity, limbSwing, limbSwingAmount, ageInTicks);
        int i = entity.getAttackAnimationTick();
        if (i > 0) {
            this.RightArm.xRot = this.LeftArm.xRot = -1.0f + 1.5f * Mth.triangleWave((float)((float)i - ageInTicks), (float)10.0f);
        } else {
            this.RightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
            this.LeftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.RightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.LeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

