/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.twilight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;

public class ModelSoulSpider<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("soul_spider");
    private final ModelPart body;
    private final ModelPart leg1top;
    private final ModelPart leg1middle;
    private final ModelPart leg1bottom;
    private final ModelPart leg2top;
    private final ModelPart leg2middle;
    private final ModelPart leg2bottom;
    private final ModelPart leg3top;
    private final ModelPart leg4top;
    private final ModelPart leg3middle;
    private final ModelPart leg4middle;
    private final ModelPart leg3bottom;
    private final ModelPart leg4bottom;

    public ModelSoulSpider(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.body = root.getChild("body");
        this.leg1top = root.getChild("leg1top");
        this.leg1middle = root.getChild("leg1middle");
        this.leg1bottom = root.getChild("leg1bottom");
        this.leg2top = root.getChild("leg2top");
        this.leg2middle = root.getChild("leg2middle");
        this.leg2bottom = root.getChild("leg2bottom");
        this.leg3top = root.getChild("leg3top");
        this.leg4top = root.getChild("leg4top");
        this.leg3middle = root.getChild("leg3middle");
        this.leg4middle = root.getChild("leg4middle");
        this.leg3bottom = root.getChild("leg3bottom");
        this.leg4bottom = root.getChild("leg4bottom");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(0.0f, 0.0f, 0.0f, 5.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-2.5f, (float)17.0f, (float)-3.0f));
        partdefinition.addOrReplaceChild("leg1top", CubeListBuilder.create().texOffs(0, 10).mirror().addBox(0.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)18.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.8727f));
        partdefinition.addOrReplaceChild("leg1middle", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-0.5f, 3.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.5f, (float)18.2f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.6109f));
        partdefinition.addOrReplaceChild("leg1bottom", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-1.5f, 4.5f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.75f, (float)18.3f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        partdefinition.addOrReplaceChild("leg2top", CubeListBuilder.create().texOffs(0, 10).mirror().addBox(0.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)18.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.8727f));
        partdefinition.addOrReplaceChild("leg2middle", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-0.5f, 3.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.5f, (float)18.2f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.6109f));
        partdefinition.addOrReplaceChild("leg2bottom", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-1.5f, 4.5f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.8f, (float)18.3f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        partdefinition.addOrReplaceChild("leg3top", CubeListBuilder.create().texOffs(0, 10).mirror().addBox(-2.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)18.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.8727f));
        partdefinition.addOrReplaceChild("leg4top", CubeListBuilder.create().texOffs(0, 10).mirror().addBox(-2.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)18.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-0.8727f));
        partdefinition.addOrReplaceChild("leg3middle", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-1.5f, 3.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)2.5f, (float)17.6f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        partdefinition.addOrReplaceChild("leg4middle", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-1.5f, 3.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)2.5f, (float)17.6f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        partdefinition.addOrReplaceChild("leg3bottom", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-0.5f, 4.5f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)2.8f, (float)18.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        partdefinition.addOrReplaceChild("leg4bottom", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-0.5f, 4.5f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)2.9f, (float)18.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.leg1bottom.xRot = this.leg2bottom.xRot = (float)Math.sin(limbSwing / 2.0f) * limbSwingAmount * 1.3f;
        this.leg2middle.xRot = this.leg2bottom.xRot;
        this.leg1middle.xRot = this.leg2bottom.xRot;
        this.leg2top.xRot = this.leg2bottom.xRot;
        this.leg1top.xRot = this.leg2bottom.xRot;
        this.leg3bottom.xRot = this.leg4bottom.xRot = (float)Math.cos(limbSwing / 2.0f) * limbSwingAmount * 1.3f;
        this.leg4middle.xRot = this.leg4bottom.xRot;
        this.leg3middle.xRot = this.leg4bottom.xRot;
        this.leg4top.xRot = this.leg4bottom.xRot;
        this.leg3top.xRot = this.leg4bottom.xRot;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leg1top.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leg1middle.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leg1bottom.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leg2top.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leg2middle.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leg2bottom.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leg3top.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leg4top.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leg3middle.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leg4middle.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leg3bottom.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leg4bottom.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

