/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.twilight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.eden.EntityMadivel;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelMadivel
extends EntityModel<EntityMadivel> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("madivel");
    public final ModelPart body;
    public final ModelPart edenSpirit;
    public final ModelPart leftSun;
    public final ModelPart rightSun;
    public final ModelPart rightLeg;
    public final ModelPart leftLeg;
    public final ModelPart rightArm;
    public final ModelPart leftArm;

    public ModelMadivel(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.body = root.getChild("body");
        this.edenSpirit = root.getChild("eden_spirit");
        this.leftSun = this.edenSpirit.getChild("left_sun");
        this.rightSun = this.edenSpirit.getChild("right_sun");
        this.rightLeg = this.body.getChild("right_leg");
        this.leftLeg = this.body.getChild("left_leg");
        this.rightArm = this.body.getChild("right_arm");
        this.leftArm = this.body.getChild("left_arm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-9.0f, -20.0f, -8.0f, 18.0f, 19.0f, 18.0f, cubeDef).texOffs(54, 0).addBox(-5.5f, -1.0f, -5.0f, 11.0f, 5.0f, 12.0f, cubeDef).texOffs(0, 37).addBox(-9.0f, -27.0f, -6.0f, 18.0f, 7.0f, 14.0f, cubeDef).texOffs(72, 17).addBox(-5.0f, -26.0f, -4.0f, 10.0f, 10.0f, 9.0f, cubeDef), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        body.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(137, 0).addBox(-5.0f, 1.0f, -3.0f, 4.0f, 21.0f, 7.0f, cubeDef), PartPose.offset((float)-4.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(88, 36).addBox(1.0f, 1.0f, -3.0f, 4.0f, 21.0f, 7.0f, cubeDef), PartPose.offset((float)4.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(100, 97).addBox(0.0f, -2.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDef).texOffs(26, 88).addBox(1.0f, 6.0f, -3.0f, 6.0f, 20.0f, 6.0f, cubeDef), PartPose.offset((float)9.0f, (float)-16.0f, (float)2.0f));
        body.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(100, 0).addBox(-8.0f, -2.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDef).texOffs(84, 79).addBox(-7.0f, 6.0f, -3.0f, 6.0f, 20.0f, 6.0f, cubeDef), PartPose.offset((float)-9.0f, (float)-16.0f, (float)2.0f));
        PartDefinition edenSpirit = partdefinition.addOrReplaceChild("eden_spirit", CubeListBuilder.create().texOffs(54, 0).addBox(-1.5f, -5.0f, -2.25f, 3.0f, 5.0f, 2.0f, cubeDef).texOffs(0, 37).addBox(-1.5f, -8.0f, -0.25f, 3.0f, 5.0f, 3.0f, cubeDef), PartPose.offset((float)0.0f, (float)-28.0f, (float)2.25f));
        edenSpirit.addOrReplaceChild("eden_spirit_head", CubeListBuilder.create().texOffs(0, 103).addBox(-2.5f, -5.25f, -4.0f, 5.0f, 5.0f, 4.0f, cubeDef).texOffs(24, 58).addBox(-4.0f, -7.25f, -2.0f, 8.0f, 8.0f, 0.0f, cubeDef), PartPose.offset((float)0.0f, (float)-7.75f, (float)0.75f));
        edenSpirit.addOrReplaceChild("left_sun", CubeListBuilder.create().texOffs(0, 0).addBox(7.5f, -4.5f, 0.25f, 9.0f, 9.0f, 0.0f, cubeDef).texOffs(101, 16).addBox(9.5f, -2.5f, -2.75f, 5.0f, 5.0f, 5.0f, cubeDef), PartPose.offset((float)0.0f, (float)-4.5f, (float)0.0f));
        edenSpirit.addOrReplaceChild("right_sun", CubeListBuilder.create().texOffs(0, 9).addBox(-17.5f, -4.5f, 0.25f, 9.0f, 9.0f, 0.0f, cubeDef).texOffs(0, 93).addBox(-15.5f, -2.5f, -2.75f, 5.0f, 5.0f, 5.0f, cubeDef), PartPose.offset((float)0.0f, (float)-4.5f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void setupAnim(EntityMadivel entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.edenSpirit.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.edenSpirit.xRot = headPitch * ((float)Math.PI / 180);
        float orbitRadius = 2.0f;
        float orbitSpeed = 0.1f;
        float sun1OrbitAngle = ageInTicks * orbitSpeed;
        float sun1OffsetX = Mth.cos((float)sun1OrbitAngle) * orbitRadius;
        float sun1OffsetZ = Mth.sin((float)sun1OrbitAngle) * orbitRadius;
        this.leftSun.x = this.edenSpirit.x + sun1OffsetX + 0.5f;
        this.leftSun.z = this.edenSpirit.z + sun1OffsetZ - 4.0f;
        float rightSunOrbitAngle = ageInTicks * orbitSpeed * 0.8f;
        float rightSunOffsetX = Mth.cos((float)rightSunOrbitAngle) * orbitRadius;
        float rightSunOffsetZ = Mth.sin((float)rightSunOrbitAngle) * orbitRadius;
        this.rightSun.x = this.edenSpirit.x + rightSunOffsetX + 0.5f;
        this.rightSun.z = this.edenSpirit.z + rightSunOffsetZ - 4.0f;
        this.leftArm.zRot = 0.0f;
        this.rightArm.zRot = 0.0f;
        this.leftArm.yRot = 0.0f;
        this.rightArm.yRot = 0.0f;
        AnimationUtils.bobModelPart((ModelPart)this.rightArm, (float)ageInTicks, (float)1.0f);
        AnimationUtils.bobModelPart((ModelPart)this.leftArm, (float)ageInTicks, (float)-1.0f);
        float f = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        float f1 = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.body.zRot = f * 0.05f;
        this.rightLeg.xRot = f;
        this.leftLeg.xRot = f1;
    }

    public void prepareMobModel(EntityMadivel entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        super.prepareMobModel((Entity)entity, limbSwing, limbSwingAmount, ageInTicks);
        float healthFraction = entity.getHealth() / entity.getMaxHealth();
        if (healthFraction < 0.33333334f) {
            this.leftSun.visible = false;
            this.rightSun.visible = false;
        } else if (healthFraction < 0.6666667f) {
            this.leftSun.visible = false;
            this.rightSun.visible = true;
        } else {
            this.leftSun.visible = true;
            this.rightSun.visible = true;
        }
        int i = entity.getAttackAnimationTick();
        if (i > 0) {
            this.rightArm.xRot = this.leftArm.xRot = -1.5f + 1.5f * Mth.triangleWave((float)((float)i - ageInTicks), (float)10.0f);
        } else {
            this.rightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
            this.leftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.edenSpirit.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

