/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.twilight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.eden.EntityGlinthop;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelGlinthop
extends EntityModel<EntityGlinthop> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("glinthop");
    public final ModelPart Spine;
    public final ModelPart Body;
    public final ModelPart Head;
    public final ModelPart RightEar;
    public final ModelPart LeftEar;
    public final ModelPart BackRightLeg;
    public final ModelPart BackLeftLeg;
    public final ModelPart FrontRightLeg;
    public final ModelPart FrontLeftLeg;
    public final ModelPart Tail;

    public ModelGlinthop(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Spine = root.getChild("Spine");
        this.Body = this.Spine.getChild("Body");
        this.Head = this.Body.getChild("Head");
        this.RightEar = this.Head.getChild("RightEar");
        this.LeftEar = this.Head.getChild("LeftEar");
        this.BackRightLeg = root.getChild("BackRightLeg");
        this.BackLeftLeg = root.getChild("BackLeftLeg");
        this.FrontRightLeg = root.getChild("FrontRightLeg");
        this.FrontLeftLeg = root.getChild("FrontLeftLeg");
        this.Tail = this.Body.getChild("Tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartPose zPose = PartPose.ZERO;
        PartDefinition Spine = partdefinition.addOrReplaceChild("Spine", CubeListBuilder.create(), PartPose.offset((float)-2.0f, (float)19.0f, (float)1.0f));
        PartDefinition Body = Spine.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 44).addBox(-3.5f, -5.75f, -4.01f, 7.0f, 8.0f, 0.0f, cubeDef).texOffs(0, 0).addBox(-2.0f, -4.75f, -3.0f, 4.0f, 5.0f, 9.0f, cubeDef).texOffs(0, 14).addBox(-3.5f, -5.75f, -4.0f, 7.0f, 8.0f, 5.0f, cubeDef), zPose);
        PartDefinition Head = Body.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 14).addBox(-0.5f, 1.0f, -4.5f, 1.0f, 1.0f, 1.0f, cubeDef).texOffs(20, 23).addBox(-2.5f, -2.0f, -4.0f, 5.0f, 6.0f, 4.0f, cubeDef), zPose);
        Head.addOrReplaceChild("RightEar", CubeListBuilder.create().texOffs(22, 33).addBox(-1.0f, -2.5f, -0.75f, 2.0f, 2.0f, 1.0f, cubeDef).texOffs(4, 7).addBox(-2.0f, -3.5f, 0.25f, 2.0f, 2.0f, 0.0f, cubeDef), PartPose.offset((float)-2.0f, (float)-1.5f, (float)-0.25f));
        Head.addOrReplaceChild("LeftEar", CubeListBuilder.create().texOffs(30, 19).addBox(-1.0f, -2.5f, -0.75f, 2.0f, 2.0f, 1.0f, cubeDef).texOffs(0, 7).addBox(0.0f, -3.5f, 0.25f, 2.0f, 2.0f, 0.0f, cubeDef), PartPose.offset((float)2.0f, (float)-1.5f, (float)-0.25f));
        Head.addOrReplaceChild("RightWhisker", CubeListBuilder.create().texOffs(24, 19).addBox(-3.5f, -2.0f, 0.0f, 3.0f, 4.0f, 0.0f, cubeDef), PartPose.offset((float)-1.5f, (float)2.0f, (float)-3.0f));
        Head.addOrReplaceChild("LeftWhisker", CubeListBuilder.create().texOffs(9, 27).addBox(0.5f, -2.0f, 0.0f, 3.0f, 4.0f, 0.0f, cubeDef), PartPose.offset((float)1.5f, (float)2.0f, (float)-3.0f));
        partdefinition.addOrReplaceChild("BackRightLeg", CubeListBuilder.create().texOffs(21, 9).addBox(-2.0f, -3.0f, -2.5f, 2.0f, 5.0f, 5.0f, cubeDef).texOffs(14, 31).addBox(-2.0f, 2.0f, 0.5f, 2.0f, 4.0f, 2.0f, cubeDef), zPose);
        partdefinition.addOrReplaceChild("BackLeftLeg", CubeListBuilder.create().texOffs(0, 27).addBox(0.0f, -3.0f, -2.5f, 2.0f, 5.0f, 5.0f, cubeDef).texOffs(33, 0).addBox(0.0f, 2.0f, 0.5f, 2.0f, 4.0f, 2.0f, cubeDef), zPose);
        partdefinition.addOrReplaceChild("FrontRightLeg", CubeListBuilder.create().texOffs(31, 6).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 5.0f, 2.0f, cubeDef), zPose);
        partdefinition.addOrReplaceChild("FrontLeftLeg", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 5.0f, 2.0f, cubeDef), zPose);
        Body.addOrReplaceChild("Tail", CubeListBuilder.create().texOffs(17, 0).addBox(-2.0f, -3.0f, -1.0f, 4.0f, 4.0f, 4.0f, cubeDef), zPose);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(EntityGlinthop entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = (float)Math.PI * 2 + Mth.cos((float)(ageInTicks * 0.05f + limbSwing * 0.1f)) * 0.05f + limbSwingAmount * 0.3f;
        this.RightEar.zRot = -f;
        this.LeftEar.zRot = f;
        this.Head.yRot = netHeadYaw * ((float)Math.PI / 180);
        float f1 = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        float f2 = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.Tail.yRot = entity.isAngry() ? 0.0f : f1 * 0.25f;
        if (entity.isInSittingPose()) {
            this.Head.setPos(0.0f, -3.5f, -3.5f);
            this.Body.setPos(2.0f, -1.25f, -2.0f);
            this.Head.xRot = headPitch * ((float)Math.PI / 180) + 0.5235988f;
            this.Body.xRot = -0.7853982f;
            this.Body.zRot = 0.0f;
            this.Tail.setPos(0.0f, -3.75f, 7.0f);
            this.BackRightLeg.setPos(-1.01f, 21.5f, 3.0f);
            this.BackLeftLeg.setPos(1.01f, 21.5f, 3.0f);
            this.BackLeftLeg.xRot = 4.712389f;
            this.BackRightLeg.xRot = 4.712389f;
            this.FrontRightLeg.setPos(-2.0f, 20.0f, -3.0f);
            this.FrontLeftLeg.setPos(2.0f, 20.0f, -3.0f);
            this.FrontLeftLeg.xRot = 5.811947f;
            this.FrontRightLeg.xRot = 5.811947f;
        } else {
            this.Head.setPos(0.0f, -4.5f, -3.0f);
            this.Body.setPos(2.0f, -1.25f, -2.0f);
            this.Head.xRot = headPitch * ((float)Math.PI / 180);
            this.Body.xRot = 0.0f;
            this.Body.zRot = f1 * 0.05f;
            this.Tail.setPos(0.0f, -3.75f, 7.0f);
            this.BackRightLeg.setPos(-1.0f, 18.0f, 3.0f);
            this.BackLeftLeg.setPos(1.0f, 18.0f, 3.0f);
            this.FrontRightLeg.setPos(-2.0f, 20.0f, -3.0f);
            this.FrontLeftLeg.setPos(2.0f, 20.0f, -3.0f);
            this.BackRightLeg.xRot = this.FrontLeftLeg.xRot = f1;
            this.BackLeftLeg.xRot = this.FrontRightLeg.xRot = f2;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Spine.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.FrontLeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.FrontRightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.BackLeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.BackRightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

