/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.iceika;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.iceika.EntitySnowSkipper;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelSnowSkipper
extends EntityModel<EntitySnowSkipper> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("snow_skipper");
    public final ModelPart head;
    public final ModelPart rightWhisker;
    public final ModelPart leftWhisker;
    public final ModelPart body;
    public final ModelPart rightSail;
    public final ModelPart leftSail;
    public final ModelPart tail;
    public final ModelPart rightFrontLeg;
    public final ModelPart rightMiddleLeg;
    public final ModelPart rightHindLeg;
    public final ModelPart leftFrontLeg;
    public final ModelPart leftMiddleLeg;
    public final ModelPart leftHindLeg;

    public ModelSnowSkipper(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.head = root.getChild("head");
        this.rightWhisker = this.head.getChild("right_whisker");
        this.leftWhisker = this.head.getChild("left_whisker");
        this.body = root.getChild("body");
        this.rightSail = this.body.getChild("right_sail");
        this.leftSail = this.body.getChild("left_sail");
        this.tail = this.body.getChild("tail");
        this.rightFrontLeg = this.body.getChild("right_front_leg");
        this.rightMiddleLeg = this.body.getChild("right_middle_leg");
        this.rightHindLeg = this.body.getChild("right_hind_leg");
        this.leftFrontLeg = this.body.getChild("left_front_leg");
        this.leftMiddleLeg = this.body.getChild("left_middle_leg");
        this.leftHindLeg = this.body.getChild("left_hind_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartDefinition Head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(12, 9).addBox(-1.0f, -1.5f, -4.0f, 2.0f, 3.0f, 4.0f, cubeDef), PartPose.offset((float)0.0f, (float)19.0f, (float)-2.0f));
        Head.addOrReplaceChild("left_whisker", CubeListBuilder.create().texOffs(0, 4).addBox(0.0f, -1.0f, 0.0f, 2.0f, 1.0f, 0.0f, cubeDef), PartPose.offsetAndRotation((float)1.0f, (float)-1.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)-0.2182f));
        Head.addOrReplaceChild("right_whisker", CubeListBuilder.create().texOffs(0, 3).addBox(-2.0f, -1.0f, 0.0f, 2.0f, 1.0f, 0.0f, cubeDef), PartPose.offsetAndRotation((float)-1.0f, (float)-1.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.2182f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -1.0f, 0.0f, 4.0f, 4.0f, 5.0f, cubeDef).texOffs(13, 0).addBox(0.0f, -3.0f, 3.3f, 0.0f, 2.0f, 3.0f, cubeDef), PartPose.offset((float)0.0f, (float)19.0f, (float)-3.0f));
        body.addOrReplaceChild("left_sail", CubeListBuilder.create().texOffs(8, 6).addBox(0.0f, -3.5f, -0.5f, 0.0f, 3.0f, 3.0f, cubeDef), PartPose.offsetAndRotation((float)1.5f, (float)-0.5f, (float)0.8f, (float)0.0f, (float)0.0f, (float)0.3054f));
        body.addOrReplaceChild("right_sail", CubeListBuilder.create().texOffs(8, 6).addBox(0.0f, -3.5f, -0.5f, 0.0f, 3.0f, 3.0f, cubeDef), PartPose.offsetAndRotation((float)-1.5f, (float)-0.5f, (float)0.8f, (float)0.0f, (float)0.0f, (float)-0.3054f));
        body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 9).addBox(-1.0f, -2.0f, 0.0f, 2.0f, 4.0f, 4.0f, cubeDef), PartPose.offset((float)0.0f, (float)1.0f, (float)5.0f));
        body.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(13, 0).addBox(-1.0f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, cubeDef), PartPose.offset((float)-1.0f, (float)3.0f, (float)0.5f));
        body.addOrReplaceChild("right_middle_leg", CubeListBuilder.create().texOffs(0, 9).addBox(-1.0f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, cubeDef), PartPose.offset((float)-1.0f, (float)3.0f, (float)2.5f));
        body.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, cubeDef), PartPose.offset((float)-1.0f, (float)3.0f, (float)4.5f));
        body.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(0, 17).addBox(0.0f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, cubeDef), PartPose.offset((float)1.0f, (float)3.0f, (float)0.5f));
        body.addOrReplaceChild("left_middle_leg", CubeListBuilder.create().texOffs(11, 16).addBox(0.0f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, cubeDef), PartPose.offset((float)1.0f, (float)3.0f, (float)2.5f));
        body.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(15, 16).addBox(0.0f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, cubeDef), PartPose.offset((float)1.0f, (float)3.0f, (float)4.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)24, (int)24);
    }

    public void setupAnim(EntitySnowSkipper entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180) / 2.0f;
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180) / 2.0f;
        float f = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        float f1 = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        float f2 = 0.19634955f + Mth.cos((float)(ageInTicks * 0.05f + limbSwing * 0.2f)) * 0.08f + limbSwingAmount * 0.2f;
        this.rightWhisker.yRot = f2 + 0.6981f;
        this.leftWhisker.yRot = -f2 - 0.6981f;
        this.body.zRot = f * 0.02f;
        this.rightSail.yRot = -f2;
        this.leftSail.yRot = f2;
        this.tail.yRot = f * 0.2f;
        this.leftMiddleLeg.xRot = this.leftHindLeg.xRot = f1;
        this.rightFrontLeg.xRot = this.leftHindLeg.xRot;
        this.rightMiddleLeg.xRot = this.rightHindLeg.xRot = f;
        this.leftFrontLeg.xRot = this.rightHindLeg.xRot;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

