/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.iceika;

import com.mojang.blaze3d.vertex.PoseStack;
import divinerpg.entities.iceika.gruzzorlug.Gruzzorlug;
import divinerpg.items.ranged.ItemRangedWeapon;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BowItem;

public class ModelGruzzorlug
extends HumanoidModel<Gruzzorlug> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("gruzzorlug");
    public final ModelPart eyebrow;

    public ModelGruzzorlug(ModelPart part) {
        super(part);
        this.eyebrow = this.head.getChild("eyebrow");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartDefinition Head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(24, 0).addBox(-3.0f, -7.0f, -3.0f, 6.0f, 7.0f, 6.0f, cubeDef).texOffs(20, 0).addBox(-1.0f, -4.0f, -4.0f, 2.0f, 3.0f, 1.0f, cubeDef).texOffs(0, 0).addBox(-4.0f, -2.0f, -4.99f, 8.0f, 8.0f, 2.0f, cubeDef).texOffs(0, 0).addBox(0.0f, -14.0f, -3.0f, 0.0f, 12.0f, 12.0f, cubeDef), PartPose.ZERO);
        Head.addOrReplaceChild("eyebrow", CubeListBuilder.create().texOffs(42, 0).addBox(-4.0f, -1.0f, -1.0f, 8.0f, 2.0f, 2.0f, cubeDef), PartPose.offset((float)0.0f, (float)0.0f, (float)-3.99f));
        Head.addOrReplaceChild("moustache", CubeListBuilder.create().texOffs(44, 19).addBox(-5.0f, -2.5f, -1.25f, 10.0f, 3.0f, 2.0f, cubeDef), PartPose.offset((float)0.0f, (float)0.18f, (float)-4.0f));
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(24, 47).addBox(-3.0f, -7.0f, -3.0f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.ZERO);
        PartDefinition Body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(19, 19).addBox(-5.0f, -10.0f, -3.0f, 10.0f, 11.0f, 5.0f, cubeDef), PartPose.offset((float)0.0f, (float)0.0f, (float)0.5f));
        Body.addOrReplaceChild("belly", CubeListBuilder.create().texOffs(8, 35).addBox(-5.5f, 7.0f, -4.0f, 11.0f, 4.0f, 3.0f, cubeDef), PartPose.offset((float)0.0f, (float)-10.5f, (float)-1.01f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 24).addBox(-2.0f, 0.0f, -2.5f, 4.0f, 6.0f, 5.0f, cubeDef), PartPose.offset((float)-3.0f, (float)0.0f, (float)-1.5f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(43, 8).addBox(-2.0f, 0.0f, -2.5f, 4.0f, 6.0f, 5.0f, cubeDef), PartPose.offset((float)3.0f, (float)0.0f, (float)-1.5f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(44, 30).addBox(-1.5f, -1.0f, -2.5f, 3.0f, 12.0f, 5.0f, cubeDef), PartPose.offset((float)0.0f, (float)0.0f, (float)-0.5f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(8, 42).addBox(-1.5f, -1.0f, -2.5f, 3.0f, 12.0f, 5.0f, cubeDef), PartPose.offset((float)0.0f, (float)0.0f, (float)-0.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void prepareMobModel(Gruzzorlug entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        this.rightArmPose = this.leftArmPose = HumanoidModel.ArmPose.EMPTY;
        if ((entity.getMainHandItem().getItem() instanceof BowItem || entity.getMainHandItem().getItem() instanceof ItemRangedWeapon) && entity.isAggressive()) {
            if (entity.getMainArm() == HumanoidArm.RIGHT) {
                this.rightArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;
            } else {
                this.leftArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
        }
        super.prepareMobModel((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks);
    }

    public void setupAnim(Gruzzorlug entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.leftArm.y = 8.0f;
        this.rightArm.y = 8.0f;
        this.rightArm.x = -6.5f;
        this.leftArm.x = 6.5f;
        this.leftLeg.y = 18.0f;
        this.rightLeg.y = 18.0f;
        this.eyebrow.y = entity.isAggressive() ? -5.0f : -4.0f;
        this.hat.y = 7.01f;
        this.head.y = 7.01f;
        this.body.y = 17.0f;
    }

    public void translateToHand(HumanoidArm arm, PoseStack stack) {
        float f = arm == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        ModelPart modelpart = this.getArm(arm);
        modelpart.x += f;
        modelpart.translateAndRotate(stack);
        modelpart.x -= f;
    }
}

