/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.iceika;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.base.EntityDivineWaterMob;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class ModelGhostGlider
extends EntityModel<EntityDivineWaterMob> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("ghost_glider");
    final ModelPart body;
    final ModelPart rightWing;
    final ModelPart leftWing;

    public ModelGhostGlider(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.body = root.getChild("Body");
        this.rightWing = root.getChild("RightWing");
        this.leftWing = root.getChild("LeftWing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -9.0f, -3.0f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition MiddleTendril = Body.addOrReplaceChild("MiddleTendril", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        MiddleTendril.addOrReplaceChild("MiddleTendril_r1", CubeListBuilder.create().texOffs(0, 22).addBox(-0.5f, -1.0f, -1.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)-2.5f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition LeftTendril = Body.addOrReplaceChild("LeftTendril", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        LeftTendril.addOrReplaceChild("LeftTendril_r1", CubeListBuilder.create().texOffs(0, 22).addBox(-0.5f, -1.0f, -0.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-3.0f, (float)-3.5f, (float)-0.0436f, (float)0.0f, (float)-0.1309f));
        PartDefinition RightTendril = Body.addOrReplaceChild("RightTendril", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        RightTendril.addOrReplaceChild("RightTendril_r1", CubeListBuilder.create().texOffs(0, 22).addBox(-0.5f, -1.0f, -0.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)-3.0f, (float)-3.5f, (float)-0.0436f, (float)0.0f, (float)0.1309f));
        PartDefinition Tail = Body.addOrReplaceChild("Tail", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-8.0f, (float)1.5f));
        Tail.addOrReplaceChild("BackTailSegment", CubeListBuilder.create().texOffs(39, 0).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)4.5f));
        Tail.addOrReplaceChild("MiddleTailSegment", CubeListBuilder.create().texOffs(31, 0).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)2.5f));
        Tail.addOrReplaceChild("FrontTailSegment", CubeListBuilder.create().texOffs(21, 0).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.5f));
        partdefinition.addOrReplaceChild("RightWing", CubeListBuilder.create().texOffs(15, 6).addBox(-4.5f, -0.5f, -1.5f, 5.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)14.5f, (float)0.5f));
        partdefinition.addOrReplaceChild("LeftWing", CubeListBuilder.create().texOffs(15, 14).addBox(-0.5f, -0.5f, -1.5f, 5.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)14.5f, (float)0.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(EntityDivineWaterMob entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.rightWing.zRot = (float)Math.sin(10.0 * (double)ageInTicks / 57.29577951308232) * 0.3f;
        this.leftWing.zRot = -this.rightWing.zRot;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightWing.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftWing.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

