/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.iceika;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.iceika.EntityFractite;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelFractite
extends EntityModel<EntityFractite> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("fractite");
    private final ModelPart frostBody;
    private final ModelPart shard1;
    private final ModelPart shard2;
    private final ModelPart shard7;
    private final ModelPart shard8;
    private final ModelPart shard4;
    private final ModelPart shard3;
    private final ModelPart shard5;
    private final ModelPart shard6;

    public ModelFractite(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.frostBody = root.getChild("frostBody");
        this.shard1 = root.getChild("shard1");
        this.shard2 = root.getChild("shard2");
        this.shard7 = root.getChild("shard7");
        this.shard8 = root.getChild("shard8");
        this.shard4 = root.getChild("shard4");
        this.shard3 = root.getChild("shard3");
        this.shard5 = root.getChild("shard5");
        this.shard6 = root.getChild("shard6");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("frostBody", CubeListBuilder.create().texOffs(0, 11).mirror().addBox(0.0f, 0.0f, 0.0f, 8.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.0f, (float)5.0f, (float)-4.0f));
        partdefinition.addOrReplaceChild("shard1", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(8.0f, 0.0f, 0.0f, 9.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)1.0f, (float)8.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        partdefinition.addOrReplaceChild("shard2", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-19.0f, 0.0f, 0.0f, 9.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        partdefinition.addOrReplaceChild("shard7", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(10.0f, 0.0f, 0.0f, 10.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        partdefinition.addOrReplaceChild("shard8", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-19.0f, 0.0f, 0.0f, 10.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.0f, (float)9.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        partdefinition.addOrReplaceChild("shard4", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-6.0f, -8.0f, 0.0f, 15.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)1.5708f));
        partdefinition.addOrReplaceChild("shard3", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-7.0f, 7.0f, 0.0f, 15.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)1.5708f));
        partdefinition.addOrReplaceChild("shard5", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-8.0f, -7.0f, 0.0f, 14.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)1.0f, (float)9.0f, (float)-2.0f));
        partdefinition.addOrReplaceChild("shard6", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-7.0f, 7.0f, 0.0f, 14.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)9.0f, (float)-2.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(EntityFractite entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.shard1.xRot = Mth.cos((float)(ageInTicks * 0.1f)) * (float)Math.PI;
        this.shard2.xRot = Mth.cos((float)(ageInTicks * 0.1f)) * (float)Math.PI;
        this.shard3.xRot = Mth.cos((float)(ageInTicks * 0.1f)) * (float)Math.PI;
        this.shard4.xRot = Mth.cos((float)(ageInTicks * 0.1f)) * (float)Math.PI;
        this.shard5.xRot = Mth.cos((float)(ageInTicks * 0.1f)) * (float)Math.PI;
        this.shard6.xRot = Mth.cos((float)(ageInTicks * 0.1f)) * (float)Math.PI;
        this.shard7.xRot = Mth.cos((float)(ageInTicks * 0.1f)) * (float)Math.PI;
        this.shard8.xRot = Mth.cos((float)(ageInTicks * 0.1f)) * (float)Math.PI;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.frostBody.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.shard1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.shard2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.shard7.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.shard8.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.shard4.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.shard3.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.shard5.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.shard6.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

