/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.iceika;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.iceika.EntityBlubbertusk;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class ModelBlubbertusk
extends EntityModel<EntityBlubbertusk> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("blubbertusk");
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart neck;
    private final ModelPart leftFin;
    private final ModelPart leftFinR1;
    private final ModelPart rightFin;
    private final ModelPart tail;
    private final ModelPart tailEnd;

    public ModelBlubbertusk(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.body = root.getChild("Body");
        this.leftFin = this.body.getChild("LeftFin");
        this.rightFin = this.body.getChild("RightFin");
        this.neck = this.body.getChild("Neck");
        this.head = this.neck.getChild("Head");
        this.tail = this.body.getChild("Tail");
        this.tailEnd = this.tail.getChild("TailEnd");
        this.leftFinR1 = this.tailEnd.getChild("leftFin_r1");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -11.0f, -9.0f, 12.0f, 11.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition Neck = Body.addOrReplaceChild("Neck", CubeListBuilder.create().texOffs(0, 26).addBox(-5.5f, -7.0f, -4.3265f, 11.0f, 11.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)-8.0f));
        PartDefinition Head = Neck.addOrReplaceChild("Head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-4.0f, (float)-1.0f));
        PartDefinition Skull = Head.addOrReplaceChild("Skull", CubeListBuilder.create().texOffs(48, 43).addBox(-3.0f, -4.0f, -8.0f, 6.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(39, 0).addBox(-4.0f, -5.0f, -6.0f, 8.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-2.5f, -2.0f, -7.5f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(4, 0).addBox(1.5f, -2.0f, -7.5f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.ZERO);
        Skull.addOrReplaceChild("RightWhisker", CubeListBuilder.create().texOffs(8, 0).addBox(-2.0f, -1.5f, 0.0f, 2.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-1.5f, (float)-7.0f));
        Skull.addOrReplaceChild("LeftWhisker", CubeListBuilder.create().texOffs(0, 8).addBox(0.0f, -1.5f, 0.0f, 2.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-1.5f, (float)-7.0f));
        PartDefinition Tail = Body.addOrReplaceChild("Tail", CubeListBuilder.create().texOffs(36, 26).addBox(-4.5f, -6.0f, 0.0f, 9.0f, 9.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)4.0f));
        PartDefinition TailEnd = Tail.addOrReplaceChild("TailEnd", CubeListBuilder.create().texOffs(29, 43).addBox(-3.0f, -3.5f, -2.0f, 6.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)9.0f));
        TailEnd.addOrReplaceChild("leftFin_r1", CubeListBuilder.create().texOffs(0, 52).addBox(-0.5f, -2.5f, -1.0f, 6.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 44).addBox(-7.5f, -2.5f, -1.0f, 6.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)3.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition LeftFin = Body.addOrReplaceChild("LeftFin", CubeListBuilder.create(), PartPose.offset((float)6.0f, (float)-4.0f, (float)-6.0f));
        LeftFin.addOrReplaceChild("leftFin_r2", CubeListBuilder.create().texOffs(15, 53).addBox(10.0f, -3.0f, -1.66f, 2.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-10.0f, (float)2.0f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition RightFin = Body.addOrReplaceChild("RightFin", CubeListBuilder.create(), PartPose.offset((float)-6.0f, (float)-4.0f, (float)-6.0f));
        RightFin.addOrReplaceChild("rightFin_r1", CubeListBuilder.create().texOffs(48, 50).addBox(-12.0f, -3.0f, -1.66f, 2.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)10.0f, (float)2.0f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(EntityBlubbertusk entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 360) - 0.6109f;
        this.head.yRot = netHeadYaw * ((float)Math.PI / 360);
        if (!entity.onGround() || entity.isInWater()) {
            float t = (float)(Math.cos(limbSwing * 0.6662f) * (double)limbSwingAmount / 2.0);
            this.neck.xRot = t + 0.6109f;
            this.tail.xRot = t;
            this.tailEnd.xRot = t * 2.0f;
            this.tail.yRot = t;
            this.tailEnd.yRot = t * 2.0f;
            this.tailEnd.y = -1.5f;
            this.body.xRot = headPitch * ((float)Math.PI / 180);
            this.body.yRot = netHeadYaw * ((float)Math.PI / 180);
            this.leftFinR1.y = 0.5f;
            this.rightFin.zRot = t * 2.0f + 1.5708f;
            this.leftFin.zRot = -t * 2.0f - 1.5708f;
        } else {
            float t1 = (float)(Math.cos(limbSwing * 1.5f) * (double)limbSwingAmount / 2.0);
            this.neck.xRot = t1 + 0.6109f;
            this.tail.xRot = 0.0f;
            this.tailEnd.xRot = 0.0f;
            this.tail.yRot = t1 / 2.0f;
            this.tailEnd.yRot = t1;
            this.tailEnd.y = 0.0f;
            this.body.xRot = 0.0f;
            this.body.yRot = 0.0f;
            this.leftFinR1.y = 3.0f;
            this.rightFin.zRot = 0.0f;
            this.leftFin.zRot = 0.0f;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

