/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.boss;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.boss.EntityWreck;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class ModelWreckArcanic
extends EntityModel<EntityWreck> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("wreck_arcanic");
    private final ModelPart head;
    private final ModelPart rightleg;
    private final ModelPart body;
    private final ModelPart leftleg;
    private final ModelPart rightarm;
    private final ModelPart leftarm;

    public ModelWreckArcanic(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.head = root.getChild("head");
        this.rightleg = root.getChild("rightleg");
        this.body = root.getChild("body");
        this.leftleg = root.getChild("leftleg");
        this.rightarm = root.getChild("rightarm");
        this.leftarm = root.getChild("leftarm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubedef = new CubeDeformation(0.0f);
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-4.0f, -7.0f, -4.0f, 3.0f, 8.0f, 8.0f, cubedef).mirror(false).texOffs(16, 9).mirror().addBox(-1.0f, -4.0f, -2.0f, 2.0f, 3.0f, 3.0f, cubedef).mirror(false).texOffs(5, 0).mirror().addBox(1.0f, -7.0f, -4.0f, 3.0f, 8.0f, 8.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-3.0f, (float)0.1396f, (float)0.0f, (float)0.0f));
        PartDefinition rightleg = partdefinition.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-3.0f, -3.0f, 0.0f, 2.0f, 8.0f, 4.0f, cubedef).mirror(false).texOffs(0, 18).mirror().addBox(-4.0f, -4.0f, -1.0f, 4.0f, 2.0f, 6.0f, cubedef).mirror(false).texOffs(4, 21).mirror().addBox(-5.0f, 4.6f, -0.6f, 1.0f, 8.0f, 2.0f, cubedef).mirror(false).texOffs(4, 21).mirror().addBox(0.0f, 4.6f, -0.6f, 1.0f, 8.0f, 2.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)12.0f, (float)0.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        rightleg.addOrReplaceChild("rightleg8_r1", CubeListBuilder.create().texOffs(0, 24).mirror().addBox(-8.0f, -7.3f, 2.0f, 2.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(0, 24).mirror().addBox(-2.0f, -7.3f, 2.0f, 2.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(0, 19).mirror().addBox(-6.0f, -7.3f, 2.0f, 4.0f, 8.0f, 4.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)12.0f, (float)0.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(19, 16).mirror().addBox(-4.0f, 0.0f, -2.0f, 6.0f, 12.0f, 2.0f, cubedef).mirror(false).texOffs(19, 0).mirror().addBox(-5.0f, 9.0f, -3.0f, 8.0f, 2.0f, 4.0f, cubedef).mirror(false).texOffs(19, 0).mirror().addBox(-5.0f, 5.0f, -3.0f, 8.0f, 2.0f, 4.0f, cubedef).mirror(false).texOffs(19, 0).mirror().addBox(-5.0f, 1.0f, -3.0f, 8.0f, 2.0f, 4.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)1.0f, (float)-1.0f, (float)-2.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("leftarm1_r1", CubeListBuilder.create().texOffs(42, 20).mirror().addBox(-13.5f, -22.6f, -11.5f, 4.0f, 10.0f, 2.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-1.0f, (float)25.0f, (float)2.0f, (float)-0.2912f, (float)0.3297f, (float)0.8239f));
        body.addOrReplaceChild("rightarm1_r1", CubeListBuilder.create().texOffs(42, 20).mirror().addBox(9.3f, -22.6f, -11.5f, 4.0f, 10.0f, 2.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-1.0f, (float)25.0f, (float)2.0f, (float)-0.2912f, (float)-0.3297f, (float)-0.8239f));
        PartDefinition leftleg = partdefinition.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(0, 25).mirror().addBox(-2.0f, 4.0f, -2.0f, 2.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(0, 20).mirror().addBox(0.0f, 4.0f, -2.0f, 4.0f, 8.0f, 4.0f, cubedef).mirror(false).texOffs(0, 25).mirror().addBox(4.0f, 4.0f, -2.0f, 2.0f, 2.0f, 2.0f, cubedef).mirror(false), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
        leftleg.addOrReplaceChild("leftleg4_r1", CubeListBuilder.create().texOffs(4, 21).mirror().addBox(1.0f, -6.3f, -5.2f, 1.0f, 8.0f, 2.0f, cubedef).mirror(false).texOffs(4, 21).mirror().addBox(6.0f, -6.3f, -5.2f, 1.0f, 8.0f, 2.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)12.0f, (float)0.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        leftleg.addOrReplaceChild("leftleg1_r1", CubeListBuilder.create().texOffs(0, 19).mirror().addBox(2.0f, -15.3f, -5.1f, 4.0f, 2.0f, 6.0f, cubedef).mirror(false).texOffs(0, 17).mirror().addBox(3.0f, -14.3f, -4.1f, 2.0f, 8.0f, 4.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)12.0f, (float)0.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = partdefinition.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(-7.0f, -3.0f, -2.0f, 4.0f, 7.0f, 4.0f, cubedef).mirror(false).texOffs(40, 16).mirror().addBox(-6.0f, 2.0f, -1.0f, 2.0f, 7.0f, 2.0f, cubedef).mirror(false).texOffs(40, 16).mirror().addBox(-7.0f, 7.0f, -2.0f, 4.0f, 5.0f, 4.0f, cubedef).mirror(false), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        rightarm.addOrReplaceChild("rightarm13_r1", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(21.0f, 6.0f, -3.0f, 2.0f, 5.0f, 1.0f, cubedef).mirror(false).texOffs(40, 16).mirror().addBox(21.0f, 6.0f, -1.0f, 2.0f, 5.0f, 1.0f, cubedef).mirror(false).texOffs(40, 16).mirror().addBox(21.0f, 6.0f, 0.0f, 2.0f, 5.0f, 1.0f, cubedef).mirror(false).texOffs(40, 16).mirror().addBox(21.0f, 6.0f, 2.0f, 2.0f, 5.0f, 1.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-19.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.6545f));
        rightarm.addOrReplaceChild("rightarm6_r1", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(11.0f, -26.0f, 2.0f, 2.0f, 5.0f, 1.0f, cubedef).mirror(false).texOffs(40, 16).mirror().addBox(11.0f, -26.0f, 0.0f, 2.0f, 5.0f, 1.0f, cubedef).mirror(false).texOffs(40, 16).mirror().addBox(11.0f, -26.0f, -1.0f, 2.0f, 5.0f, 1.0f, cubedef).mirror(false).texOffs(40, 16).mirror().addBox(11.0f, -26.0f, -3.0f, 2.0f, 5.0f, 1.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-19.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)2.2253f));
        PartDefinition leftarm = partdefinition.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(3.0f, 8.0f, -2.0f, 4.0f, 4.0f, 4.0f, cubedef).mirror(false).texOffs(40, 16).mirror().addBox(3.0f, 8.0f, -9.0f, 4.0f, 4.0f, 4.0f, cubedef).mirror(false).texOffs(38, 7).mirror().addBox(3.0f, -9.0f, -9.0f, 4.0f, 4.0f, 4.0f, cubedef).mirror(false).texOffs(56, 0).mirror().addBox(4.0f, -7.0f, -8.0f, 2.0f, 30.0f, 2.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)5.0f, (float)2.0f, (float)0.0f, (float)-0.1047f, (float)0.0f, (float)0.0f));
        leftarm.addOrReplaceChild("leftarm9_r1", CubeListBuilder.create().texOffs(28, 7).mirror().addBox(16.2f, -31.0f, -8.0f, 3.0f, 6.0f, 2.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-5.0f, (float)22.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3054f));
        leftarm.addOrReplaceChild("leftarm2_r1", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(9.0f, -7.0f, 11.0f, 2.0f, 7.0f, 2.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-5.0f, (float)22.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        leftarm.addOrReplaceChild("leftarm4_r1", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(9.0f, -19.0f, -1.2f, 2.0f, 7.0f, 2.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-5.0f, (float)22.0f, (float)0.0f, (float)-0.0262f, (float)0.0f, (float)0.0f));
        leftarm.addOrReplaceChild("leftarm3_r1", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(8.0f, -25.0f, -1.3f, 4.0f, 7.0f, 4.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-5.0f, (float)22.0f, (float)0.0f, (float)0.0349f, (float)0.0f, (float)0.0f));
        leftarm.addOrReplaceChild("leftarm6_r1", CubeListBuilder.create().texOffs(28, 7).mirror().addBox(-1.5f, -37.0f, -8.3f, 3.0f, 6.0f, 2.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-5.0f, (float)22.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(EntityWreck entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.leftleg.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
        this.rightleg.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
        this.rightarm.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * 2.0 * (double)limbSwingAmount * 0.5);
        this.leftarm.xRot = (float)(Math.cos(limbSwing * 0.6662f) * 2.0 * (double)limbSwingAmount * 0.5);
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

