/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.boss;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.boss.EntityVamacheron;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class ModelVamacheron
extends EntityModel<EntityVamacheron> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("vamacheron");
    private final ModelPart Head;
    private final ModelPart Body;
    private final ModelPart FrontRightLeg;
    private final ModelPart FrontLeftLeg;
    private final ModelPart BackRightLeg;
    private final ModelPart BackLeftLeg;
    private final ModelPart Head2;

    public ModelVamacheron(ModelPart root) {
        this.Head = root.getChild("Head");
        this.Body = root.getChild("Body");
        this.FrontRightLeg = root.getChild("FrontRightLeg");
        this.FrontLeftLeg = root.getChild("FrontLeftLeg");
        this.BackRightLeg = root.getChild("BackRightLeg");
        this.BackLeftLeg = root.getChild("BackLeftLeg");
        this.Head2 = root.getChild("Head2");
    }

    public ModelVamacheron(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Head = root.getChild("Head");
        this.Body = root.getChild("Body");
        this.FrontRightLeg = root.getChild("FrontRightLeg");
        this.FrontLeftLeg = root.getChild("FrontLeftLeg");
        this.BackRightLeg = root.getChild("BackRightLeg");
        this.BackLeftLeg = root.getChild("BackLeftLeg");
        this.Head2 = root.getChild("Head2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Head = partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(33, 33).addBox(-4.0f, -5.8f, -5.7f, 8.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(54, 12).addBox(-3.0f, -2.8f, -8.7f, 6.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.0f, (float)5.8f, (float)-8.3f, (float)0.1745f, (float)0.0f, (float)0.0f));
        Head.addOrReplaceChild("Horn_r1", CubeListBuilder.create().texOffs(14, 56).addBox(-1.0f, -7.5f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.7528f, (float)-4.4743f, (float)0.3927f, (float)0.0f, (float)0.0f));
        Head.addOrReplaceChild("RightEar_r1", CubeListBuilder.create().texOffs(55, 31).addBox(-4.9572f, -7.1226f, 1.0f, 6.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(38, 56).addBox(-4.9572f, -7.1226f, 0.99f, 6.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)-2.8f, (float)-1.7f, (float)0.0f, (float)-0.0436f, (float)-0.1309f));
        Head.addOrReplaceChild("LeftEar_r1", CubeListBuilder.create().texOffs(1, 56).addBox(-1.0f, -7.0f, 1.0f, 6.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(22, 56).addBox(-1.0f, -7.0f, 0.99f, 6.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-2.8f, (float)-1.7f, (float)0.0f, (float)0.0f, (float)0.1309f));
        Head.addOrReplaceChild("Mouth", CubeListBuilder.create().texOffs(0, 15).addBox(-3.0f, -0.5f, -1.5f, 6.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.7f, (float)-7.2f));
        partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 31).addBox(-4.0f, -4.5f, -8.75f, 8.0f, 8.0f, 17.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-5.5f, -5.5f, -9.25f, 11.0f, 12.0f, 19.0f, new CubeDeformation(0.0f)).texOffs(4, 5).addBox(-9.5f, -5.3f, -9.15f, 11.0f, 8.0f, 15.0f, new CubeDeformation(0.0f)).texOffs(4, 5).addBox(-1.5f, -5.3f, -9.15f, 11.0f, 8.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)9.5f, (float)0.75f));
        partdefinition.addOrReplaceChild("FrontRightLeg", CubeListBuilder.create().texOffs(50, 50).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)13.0f, (float)-6.0f));
        partdefinition.addOrReplaceChild("FrontLeftLeg", CubeListBuilder.create().texOffs(41, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)13.0f, (float)-6.0f));
        partdefinition.addOrReplaceChild("BackRightLeg", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)13.0f, (float)8.0f));
        partdefinition.addOrReplaceChild("BackLeftLeg", CubeListBuilder.create().texOffs(0, 31).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)13.0f, (float)8.0f));
        PartDefinition Head2 = partdefinition.addOrReplaceChild("Head2", CubeListBuilder.create().texOffs(33, 33).addBox(-4.0f, -5.8f, -5.7f, 8.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(54, 12).addBox(-3.0f, -2.8f, -8.7f, 6.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-7.0f, (float)5.8f, (float)-8.3f, (float)0.1745f, (float)0.0f, (float)0.0f));
        Head2.addOrReplaceChild("Horn_r2", CubeListBuilder.create().texOffs(14, 56).addBox(-1.0f, -7.5f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.7528f, (float)-4.4743f, (float)0.3927f, (float)0.0f, (float)0.0f));
        Head2.addOrReplaceChild("RightEar_r2", CubeListBuilder.create().texOffs(55, 31).addBox(0.0f, -6.47f, 1.0f, 6.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(38, 56).addBox(0.0f, -6.47f, 0.99f, 6.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-8.0f, (float)-2.8f, (float)-1.7f, (float)0.0f, (float)0.0f, (float)-0.1309f));
        Head2.addOrReplaceChild("LeftEar_r2", CubeListBuilder.create().texOffs(1, 56).addBox(-1.0f, -7.0f, 1.0f, 6.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(22, 56).addBox(-1.0f, -7.0f, 0.99f, 6.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-2.8f, (float)-1.7f, (float)0.0f, (float)0.0f, (float)0.1309f));
        Head2.addOrReplaceChild("Mouth2", CubeListBuilder.create().texOffs(0, 15).addBox(-3.0f, -0.5f, -1.5f, 6.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.7f, (float)-7.2f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(EntityVamacheron entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.yRot = netHeadYaw / 57.295776f;
        this.Head.xRot = headPitch / 57.295776f;
        this.Head2.yRot = netHeadYaw / 57.295776f;
        this.Head2.xRot = headPitch / 57.295776f;
        this.FrontLeftLeg.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)limbSwingAmount);
        this.FrontRightLeg.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)limbSwingAmount);
        this.BackLeftLeg.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)limbSwingAmount);
        this.BackRightLeg.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)limbSwingAmount);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.FrontRightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.FrontLeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.BackRightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.BackLeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Head2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

