/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.boss;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;

public class ModelSunstorm<T extends LivingEntity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("sunstorm");
    private final ModelPart UpperBody;
    private final ModelPart LowerBody;
    private final ModelPart LeftArm;
    private final ModelPart RightArm;
    private final ModelPart LeftLegThigh;
    private final ModelPart RightLegThigh;

    public ModelSunstorm(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.UpperBody = root.getChild("UpperBody");
        this.LowerBody = root.getChild("LowerBody");
        this.LeftArm = root.getChild("LeftArm");
        this.RightArm = root.getChild("RightArm");
        this.LeftLegThigh = root.getChild("LeftLegThigh");
        this.RightLegThigh = root.getChild("RightLegThigh");
    }

    public ModelSunstorm(ModelPart root) {
        this.UpperBody = root.getChild("UpperBody");
        this.LowerBody = root.getChild("LowerBody");
        this.LeftArm = root.getChild("LeftArm");
        this.RightArm = root.getChild("RightArm");
        this.LeftLegThigh = root.getChild("LeftLegThigh");
        this.RightLegThigh = root.getChild("RightLegThigh");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition UpperBody = partdefinition.addOrReplaceChild("UpperBody", CubeListBuilder.create().texOffs(0, 0).addBox(-12.0f, -23.0f, -6.0f, 24.0f, 22.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition LeftArm = partdefinition.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(84, 0).addBox(0.0f, -7.0f, -6.0f, 12.0f, 8.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(89, 57).addBox(1.0f, 1.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)12.0f, (float)-23.0f, (float)2.0f));
        LeftArm.addOrReplaceChild("LeftCannon", CubeListBuilder.create().texOffs(47, 53).addBox(-5.0f, 0.0f, -4.0f, 10.0f, 22.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)10.0f, (float)-1.0f));
        PartDefinition RightArm = partdefinition.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(104, 103).addBox(-9.0f, 1.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(30, 86).addBox(-12.0f, -7.0f, -6.0f, 12.0f, 8.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-12.0f, (float)-23.0f, (float)2.0f));
        RightArm.addOrReplaceChild("RightCannon", CubeListBuilder.create().texOffs(0, 64).addBox(-5.0f, 0.0f, -4.0f, 10.0f, 22.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)10.0f, (float)-1.0f));
        UpperBody.addOrReplaceChild("MiddleSoul", CubeListBuilder.create().texOffs(61, 40).addBox(-3.0f, -8.0f, -1.0f, 6.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-28.0f, (float)-8.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        UpperBody.addOrReplaceChild("RightSoul", CubeListBuilder.create().texOffs(45, 40).addBox(-3.0f, -8.0f, -1.0f, 6.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-10.0f, (float)-24.0f, (float)-8.0f, (float)-0.3491f, (float)0.0f, (float)-0.5236f));
        UpperBody.addOrReplaceChild("LeftSoul", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -8.0f, -1.0f, 6.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)10.0f, (float)-24.0f, (float)-8.0f, (float)-0.3491f, (float)0.0f, (float)0.5236f));
        UpperBody.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(34, 106).addBox(-6.0f, -8.0f, -4.0f, 12.0f, 15.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-13.0f, (float)-5.0f));
        partdefinition.addOrReplaceChild("LowerBody", CubeListBuilder.create().texOffs(0, 40).addBox(-8.0f, -2.0f, -4.0f, 16.0f, 11.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-9.0f, (float)0.0f));
        PartDefinition RightLegThigh = partdefinition.addOrReplaceChild("RightLegThigh", CubeListBuilder.create().texOffs(0, 98).addBox(-6.0f, 0.0f, -3.0f, 9.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)-4.0f, (float)1.0f));
        RightLegThigh.addOrReplaceChild("RightLegFoot", CubeListBuilder.create().texOffs(79, 76).addBox(-5.0f, 0.0f, -4.0f, 11.0f, 17.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)11.0f, (float)0.0f));
        PartDefinition LeftLegThigh = partdefinition.addOrReplaceChild("LeftLegThigh", CubeListBuilder.create().texOffs(70, 103).addBox(-3.0f, 0.0f, -3.0f, 9.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)-4.0f, (float)1.0f));
        LeftLegThigh.addOrReplaceChild("LeftLegFoot", CubeListBuilder.create().texOffs(78, 30).addBox(-6.0f, 0.0f, -4.0f, 11.0f, 17.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)11.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.RightArm.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * 2.0 * (double)limbSwingAmount * 0.5);
        this.LeftArm.xRot = (float)(Math.cos(limbSwing * 0.6662f) * 2.0 * (double)limbSwingAmount * 0.5);
        this.RightArm.yRot = 0.0f;
        this.LeftArm.yRot = 0.0f;
        this.RightArm.zRot = 0.0f;
        this.LeftArm.zRot = 0.0f;
        AnimationUtils.bobModelPart((ModelPart)this.RightArm, (float)ageInTicks, (float)1.0f);
        AnimationUtils.bobModelPart((ModelPart)this.LeftArm, (float)ageInTicks, (float)-1.0f);
        this.RightLegThigh.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
        this.LeftLegThigh.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
        this.setupAttackAnimation(entity, ageInTicks);
    }

    protected ModelPart getArm(HumanoidArm humanoidarm) {
        return this.RightArm;
    }

    private HumanoidArm getAttackArm(T p_102857_) {
        return p_102857_.getMainArm();
    }

    protected void setupAttackAnimation(T p_102858_, float p_102859_) {
        if (!(this.attackTime <= 0.0f)) {
            HumanoidArm humanoidarm = this.getAttackArm(p_102858_);
            ModelPart modelpart = this.getArm(humanoidarm);
            float f = this.attackTime;
            this.UpperBody.yRot = Mth.sin((float)(Mth.sqrt((float)f) * ((float)Math.PI * 2))) * 0.2f;
            this.RightArm.yRot += this.UpperBody.yRot;
            f = 1.0f - this.attackTime;
            f *= f;
            f *= f;
            f = 1.0f - f;
            float f1 = Mth.sin((float)(f * (float)Math.PI));
            float f2 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * 0.525f;
            modelpart.xRot -= f1 * 1.2f + f2;
            modelpart.yRot += this.UpperBody.yRot * 2.0f;
            modelpart.zRot += Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.UpperBody.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.LowerBody.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.LeftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.RightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.LeftLegThigh.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.RightLegThigh.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

