/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.boss;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.boss.EntityRaglok;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class ModelRaglok
extends EntityModel<EntityRaglok> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("raglok");
    private final ModelPart head;
    private final ModelPart leftarm;
    private final ModelPart rightleg;
    private final ModelPart leftleg;
    private final ModelPart body;
    private final ModelPart leftwing;
    private final ModelPart rightwing;
    private final ModelPart rightarm;

    public ModelRaglok(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.head = root.getChild("head");
        this.leftarm = root.getChild("leftarm");
        this.rightleg = root.getChild("rightleg");
        this.leftleg = root.getChild("leftleg");
        this.body = root.getChild("body");
        this.leftwing = root.getChild("leftwing");
        this.rightwing = root.getChild("rightwing");
        this.rightarm = root.getChild("rightarm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubedef = new CubeDeformation(0.0f);
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(270, 0).mirror().addBox(-10.0f, -16.0f, -6.0f, 20.0f, 16.0f, 16.0f, cubedef).mirror(false).texOffs(341, 19).mirror().addBox(-22.0f, -13.0f, -3.0f, 12.0f, 4.0f, 8.0f, cubedef).mirror(false).texOffs(337, 0).mirror().addBox(-22.0f, -21.0f, -3.0f, 4.0f, 8.0f, 8.0f, cubedef).mirror(false).texOffs(341, 19).mirror().addBox(10.0f, -13.0f, -3.0f, 12.0f, 4.0f, 8.0f, cubedef).mirror(false).texOffs(337, 0).mirror().addBox(18.0f, -21.0f, -3.0f, 4.0f, 8.0f, 8.0f, cubedef).mirror(false), PartPose.offset((float)0.0f, (float)-44.0f, (float)-15.0f));
        PartDefinition leftarm = partdefinition.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(381, 0).mirror().addBox(5.7615f, 35.25f, -1.4689f, 7.0f, 17.0f, 9.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)23.0f, (float)-38.0f, (float)-11.0f, (float)-0.2618f, (float)0.0f, (float)0.2618f));
        leftarm.addOrReplaceChild("leftarm4_r1", CubeListBuilder.create().texOffs(126, 2).mirror().addBox(31.5f, -41.0f, -11.0f, 9.0f, 17.0f, 11.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-23.2385f, (float)64.25f, (float)8.5311f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        leftarm.addOrReplaceChild("leftarm3_r1", CubeListBuilder.create().texOffs(120, 2).mirror().addBox(32.5f, -54.0f, -12.0f, 11.0f, 17.0f, 13.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-23.2385f, (float)64.25f, (float)8.5311f, (float)0.0f, (float)0.0f, (float)-0.1309f));
        leftarm.addOrReplaceChild("leftarm2_r1", CubeListBuilder.create().texOffs(118, 0).mirror().addBox(35.5f, -61.0f, -13.0f, 13.0f, 17.0f, 15.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-23.2385f, (float)64.25f, (float)8.5311f, (float)0.0f, (float)0.0f, (float)-0.2182f));
        partdefinition.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(413, 9).mirror().addBox(-10.6667f, 21.0f, -8.0f, 13.0f, 8.0f, 14.0f, cubedef).mirror(false).texOffs(416, 11).mirror().addBox(-10.0f, 13.0f, -7.0f, 11.0f, 8.0f, 12.0f, cubedef).mirror(false).texOffs(416, 11).mirror().addBox(-9.0f, 5.0f, -6.0f, 9.0f, 8.0f, 10.0f, cubedef).mirror(false).texOffs(468, 3).mirror().addBox(-10.0f, -3.0f, -7.0f, 10.0f, 8.0f, 12.0f, cubedef).mirror(false), PartPose.offset((float)-10.0f, (float)-5.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(413, 9).mirror().addBox(-2.0f, 21.0f, -8.0f, 13.0f, 8.0f, 14.0f, cubedef).mirror(false).texOffs(416, 11).mirror().addBox(-1.0f, 13.0f, -7.0f, 11.0f, 8.0f, 12.0f, cubedef).mirror(false).texOffs(416, 11).mirror().addBox(0.0f, 5.0f, -6.0f, 9.0f, 8.0f, 10.0f, cubedef).mirror(false).texOffs(468, 3).mirror().addBox(0.0f, -3.0f, -7.0f, 10.0f, 8.0f, 12.0f, cubedef).mirror(false), PartPose.offset((float)10.0f, (float)-5.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(18.0f, -13.0f, -1.0f, 23.0f, 18.0f, 14.0f, cubedef).mirror(false).texOffs(0, 0).mirror().addBox(-4.0f, -13.0f, -1.0f, 22.0f, 18.0f, 14.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-18.0f, (float)-34.0f, (float)-9.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("part4_r1", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(0.0f, -54.0f, -24.0f, 14.0f, 18.0f, 14.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)18.0f, (float)58.0f, (float)9.0f, (float)-0.2443f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("part3_r1", CubeListBuilder.create().texOffs(1, 0).mirror().addBox(-10.0f, -35.0f, -32.0f, 20.0f, 18.0f, 14.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)18.0f, (float)58.0f, (float)9.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("part5_r1", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-14.0f, -54.2f, -23.6f, 14.0f, 18.0f, 14.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)18.0f, (float)58.0f, (float)9.0f, (float)-0.2356f, (float)0.0f, (float)0.0f));
        PartDefinition leftwing = partdefinition.addOrReplaceChild("leftwing", CubeListBuilder.create().texOffs(181, 0).mirror().addBox(-24.0f, 2.0f, -7.0f, 5.0f, 5.0f, 5.0f, cubedef).mirror(false).texOffs(178, 11).mirror().addBox(-24.0f, -14.0f, -6.0f, 3.0f, 18.0f, 3.0f, cubedef).mirror(false).texOffs(181, 0).mirror().addBox(-25.0f, -18.0f, -7.0f, 5.0f, 5.0f, 5.0f, cubedef).mirror(false).texOffs(195, 25).mirror().addBox(-47.0f, -17.0f, -6.0f, 24.0f, 3.0f, 3.0f, cubedef).mirror(false).texOffs(206, 0).mirror().addBox(-45.0f, -14.0f, -4.0f, 23.0f, 18.0f, 0.0f, cubedef).mirror(false).texOffs(195, 25).mirror().addBox(-47.0f, 3.0f, -6.0f, 24.0f, 3.0f, 3.0f, cubedef).mirror(false).texOffs(178, 11).mirror().addBox(-47.0f, -14.0f, -6.0f, 3.0f, 17.0f, 3.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)9.0f, (float)-31.0f, (float)3.0f, (float)-0.5236f, (float)2.5307f, (float)0.4363f));
        leftwing.addOrReplaceChild("part20_r1", CubeListBuilder.create().texOffs(16, 0).mirror().addBox(-12.0f, -51.5f, 0.0f, 24.0f, 3.0f, 3.0f, cubedef).mirror(false).texOffs(206, 0).mirror().addBox(-12.1f, -69.5f, 0.0f, 23.0f, 18.0f, 0.0f, cubedef).mirror(false).texOffs(16, 0).mirror().addBox(-12.0f, -72.5f, -1.0f, 24.0f, 3.0f, 3.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-9.0f, (float)55.0f, (float)-3.0f, (float)0.0f, (float)-0.2182f, (float)0.0f));
        PartDefinition rightwing = partdefinition.addOrReplaceChild("rightwing", CubeListBuilder.create().texOffs(195, 25).mirror().addBox(-24.0f, 1.0f, -1.0f, 24.0f, 3.0f, 3.0f, cubedef).mirror(false).texOffs(206, 0).mirror().addBox(-22.0f, -17.0f, 0.0f, 23.0f, 18.0f, 0.0f, cubedef).mirror(false).texOffs(195, 25).mirror().addBox(-24.0f, -20.0f, -1.0f, 24.0f, 3.0f, 3.0f, cubedef).mirror(false).texOffs(181, 0).mirror().addBox(-25.0f, -21.0f, -2.0f, 5.0f, 5.0f, 5.0f, cubedef).mirror(false).texOffs(178, 11).mirror().addBox(-24.0f, -17.0f, -1.0f, 3.0f, 18.0f, 3.0f, cubedef).mirror(false).texOffs(181, 0).mirror().addBox(-25.0f, 0.0f, -2.0f, 5.0f, 5.0f, 5.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-7.0f, (float)-31.0f, (float)3.0f, (float)0.3491f, (float)0.6109f, (float)0.4363f));
        rightwing.addOrReplaceChild("part26_r1", CubeListBuilder.create().texOffs(206, 0).mirror().addBox(-47.5f, -71.6f, 19.0f, 23.0f, 18.0f, 0.0f, cubedef).mirror(false).texOffs(178, 11).mirror().addBox(-49.5f, -71.6f, 17.0f, 3.0f, 17.0f, 3.0f, cubedef).mirror(false).texOffs(195, 25).mirror().addBox(-49.5f, -74.6f, 17.0f, 24.0f, 3.0f, 3.0f, cubedef).mirror(false).texOffs(195, 25).mirror().addBox(-49.5f, -54.6f, 17.0f, 24.0f, 3.0f, 3.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)7.0f, (float)55.0f, (float)-3.0f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition rightarm = partdefinition.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(381, 0).mirror().addBox(7.6536f, 34.6019f, -1.6029f, 7.0f, 17.0f, 9.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-21.0f, (float)-37.6f, (float)-6.0f, (float)0.0f, (float)0.1298f, (float)2.8947f));
        rightarm.addOrReplaceChild("rightarm3_r1", CubeListBuilder.create().texOffs(126, 2).mirror().addBox(31.5f, -41.0f, -11.0f, 9.0f, 17.0f, 11.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-21.3464f, (float)63.6019f, (float)8.3971f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        rightarm.addOrReplaceChild("rightarm2_r1", CubeListBuilder.create().texOffs(120, 2).mirror().addBox(32.5f, -54.0f, -12.0f, 11.0f, 17.0f, 13.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-21.3464f, (float)63.6019f, (float)8.3971f, (float)0.0f, (float)0.0f, (float)-0.1309f));
        rightarm.addOrReplaceChild("rightarm1_r1", CubeListBuilder.create().texOffs(118, 0).mirror().addBox(35.5f, -61.0f, -13.0f, 13.0f, 17.0f, 15.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-21.3464f, (float)63.6019f, (float)8.3971f, (float)0.0f, (float)0.0f, (float)-0.2182f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)512, (int)32);
    }

    public void setupAnim(EntityRaglok entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.leftleg.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
        this.rightleg.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
        this.rightarm.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)limbSwingAmount - (double)0.2618f - (double)2.9136f);
        this.leftarm.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)limbSwingAmount - (double)0.2618f);
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftwing.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightwing.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

