/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.boss;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.boss.EntityAncientEntity;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class ModelAncientEntity
extends EntityModel<EntityAncientEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("ancient_entity");
    private final ModelPart head;
    private final ModelPart legr;
    private final ModelPart legl;
    private final ModelPart body;
    private final ModelPart legL2;
    private final ModelPart legR2;

    public ModelAncientEntity(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.head = root.getChild("head");
        this.legr = root.getChild("legr");
        this.legl = root.getChild("legl");
        this.body = root.getChild("body");
        this.legL2 = root.getChild("legL2");
        this.legR2 = root.getChild("legR2");
    }

    public ModelAncientEntity(ModelPart root) {
        this.head = root.getChild("head");
        this.legr = root.getChild("legr");
        this.legl = root.getChild("legl");
        this.body = root.getChild("body");
        this.legL2 = root.getChild("legL2");
        this.legR2 = root.getChild("legR2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-4.0f, -4.0f, -6.0f, 8.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(33, 17).mirror().addBox(4.0f, -6.3f, -13.3f, 1.0f, 1.0f, 12.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(33, 17).mirror().addBox(-5.0f, -6.3f, -13.3f, 1.0f, 1.0f, 12.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)-13.0f, (float)-19.0f));
        head.addOrReplaceChild("hornbottomr_r1", CubeListBuilder.create().texOffs(33, 17).mirror().addBox(-5.0f, -6.0f, 0.0f, 1.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)0.0f, (float)0.9599f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("hornbottoml_r1", CubeListBuilder.create().texOffs(33, 17).mirror().addBox(4.0f, -4.0f, -1.0f, 1.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-1.0f, (float)0.9599f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("legr", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-3.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-7.0f, (float)12.0f, (float)4.0f));
        partdefinition.addOrReplaceChild("legl", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-1.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)7.0f, (float)12.0f, (float)4.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(18, 4).mirror().addBox(-6.0f, -10.0f, -7.0f, 12.0f, 18.0f, 10.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(18, 4).mirror().addBox(-6.0f, -27.6f, -6.7f, 12.0f, 18.0f, 10.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)2.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("Shape8_r1", CubeListBuilder.create().texOffs(34, 4).mirror().addBox(-3.0f, 4.0f, -2.5f, 6.0f, 11.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-29.0f, (float)-2.0f, (float)1.3526f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("Shape9_r1", CubeListBuilder.create().texOffs(34, 4).mirror().addBox(-3.0f, 4.0f, -4.0f, 6.0f, 11.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-27.0f, (float)-2.0f, (float)1.3526f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("Shape7_r1", CubeListBuilder.create().texOffs(34, 4).mirror().addBox(-3.0f, 1.0f, 9.0f, 6.0f, 11.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(34, 4).mirror().addBox(-3.0f, 1.0f, 2.0f, 6.0f, 11.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-10.0f, (float)-2.0f, (float)1.3526f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("Shape6_r1", CubeListBuilder.create().texOffs(34, 4).mirror().addBox(-3.0f, 1.0f, 4.5f, 6.0f, 11.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-11.0f, (float)-2.0f, (float)1.3526f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("Shape4_r1", CubeListBuilder.create().texOffs(34, 4).mirror().addBox(-3.0f, 6.0f, 6.0f, 6.0f, 11.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)-9.0f, (float)1.3526f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("Shape3_r1", CubeListBuilder.create().texOffs(34, 4).mirror().addBox(-3.0f, -1.0f, 2.0f, 6.0f, 11.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)-2.0f, (float)1.3526f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("Shape2_r1", CubeListBuilder.create().texOffs(34, 4).mirror().addBox(-3.0f, -1.0f, 1.0f, 6.0f, 11.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-3.0f, (float)1.3526f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("Shape1_r1", CubeListBuilder.create().texOffs(34, 4).mirror().addBox(-3.0f, -6.5f, 17.0f, 6.0f, 11.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)-2.0f, (float)1.3526f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("legL2", CubeListBuilder.create().texOffs(0, 14).mirror().addBox(-1.0f, 0.0f, -4.0f, 6.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 16).mirror().addBox(-1.0f, 12.0f, -3.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 19).mirror().addBox(-1.0f, 24.0f, -2.0f, 3.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)7.0f, (float)-9.0f, (float)-16.0f));
        partdefinition.addOrReplaceChild("legR2", CubeListBuilder.create().texOffs(0, 14).mirror().addBox(-5.0f, 0.0f, -4.0f, 6.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 16).mirror().addBox(-3.0f, 12.0f, -3.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 19).mirror().addBox(-2.0f, 24.0f, -2.0f, 3.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-7.0f, (float)-9.0f, (float)-16.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(EntityAncientEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.legr.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
        this.legl.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.legr.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.legl.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.body.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.legL2.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.legR2.render(poseStack, buffer, packedLight, packedOverlay, color);
    }
}

