/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.Entity;

public class ModelEdenChest<T extends Entity>
extends Model {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("eden_chest");
    public final ModelPart lid;
    public final ModelPart storage;
    public final ModelPart chestKnobLeft;
    public final ModelPart chestKnobMiddle;
    public final ModelPart chestKnobRight;

    public ModelEdenChest(ModelPart root) {
        super(RenderType::entityCutout);
        this.lid = root.getChild("lid");
        this.storage = root.getChild("storage");
        this.chestKnobLeft = root.getChild("chestKnobLeft");
        this.chestKnobMiddle = root.getChild("chestKnobMiddle");
        this.chestKnobRight = root.getChild("chestKnobRight");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("lid", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -5.0f, -14.0f, 14.0f, 5.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)7.0f, (float)15.0f));
        partdefinition.addOrReplaceChild("storage", CubeListBuilder.create().texOffs(0, 19).addBox(0.0f, 0.0f, 0.0f, 14.0f, 10.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)6.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("chestKnobLeft", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -2.0f, -15.0f, 2.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)7.0f, (float)15.0f));
        partdefinition.addOrReplaceChild("chestKnobMiddle", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -2.0f, -15.0f, 2.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)8.0f, (float)7.0f, (float)15.0f));
        partdefinition.addOrReplaceChild("chestKnobRight", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -2.0f, -15.0f, 2.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)12.0f, (float)7.0f, (float)15.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.lid.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.storage.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.chestKnobLeft.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.chestKnobMiddle.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.chestKnobRight.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

