/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.arcana;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.arcana.EntityRazorback;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelRazorback
extends EntityModel<EntityRazorback> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("razorback");
    public final ModelPart spine;
    public final ModelPart body;
    public final ModelPart head;
    public final ModelPart tail;
    public final ModelPart rightFrontLeg;
    public final ModelPart rightHindLeg;
    public final ModelPart leftFrontLeg;
    public final ModelPart leftHindLeg;

    public ModelRazorback(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.spine = root.getChild("spine");
        this.body = this.spine.getChild("body");
        this.head = this.spine.getChild("head");
        this.tail = this.spine.getChild("tail");
        this.rightFrontLeg = this.spine.getChild("right_front_leg");
        this.rightHindLeg = this.spine.getChild("right_hind_leg");
        this.leftFrontLeg = this.spine.getChild("left_front_leg");
        this.leftHindLeg = this.spine.getChild("left_hind_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartDefinition spine = partdefinition.addOrReplaceChild("spine", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)21.0f, (float)1.0f));
        spine.addOrReplaceChild("head", CubeListBuilder.create().texOffs(13, 23).addBox(-3.0f, -2.0f, -3.0f, 6.0f, 4.0f, 3.0f, cubeDef).texOffs(24, 13).addBox(-3.0f, -4.0f, -3.0f, 6.0f, 2.0f, 3.0f, cubeDef), PartPose.offset((float)0.0f, (float)-2.99f, (float)-3.99f));
        spine.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(26, 6).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 0.0f, 6.0f, cubeDef).texOffs(26, 0).addBox(-4.0f, -0.01f, 0.0f, 8.0f, 0.0f, 6.0f, cubeDef), PartPose.offset((float)0.0f, (float)-2.0f, (float)4.0f));
        spine.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -5.0f, -3.0f, 8.0f, 5.0f, 8.0f, cubeDef).texOffs(24, 18).addBox(-4.0f, -7.0f, 1.0f, 8.0f, 3.0f, 0.0f, cubeDef).texOffs(0, 13).addBox(-4.0f, -7.0f, -3.0f, 8.0f, 2.0f, 8.0f, cubeDef).texOffs(8, 26).addBox(0.0f, -11.0f, 0.0f, 1.0f, 6.0f, 1.0f, cubeDef).texOffs(24, 30).addBox(2.0f, -8.0f, -2.0f, 1.0f, 3.0f, 1.0f, cubeDef).texOffs(20, 30).addBox(-3.0f, -8.0f, 2.0f, 1.0f, 3.0f, 1.0f, cubeDef).texOffs(12, 30).addBox(2.0f, -9.0f, 2.0f, 1.0f, 4.0f, 1.0f, cubeDef).texOffs(16, 30).addBox(-3.0f, -9.0f, -2.0f, 1.0f, 4.0f, 1.0f, cubeDef).texOffs(0, 15).addBox(0.0f, -8.0f, -4.0f, 0.0f, 3.0f, 8.0f, cubeDef).texOffs(28, 15).addBox(0.01f, -8.0f, -4.0f, 0.0f, 3.0f, 8.0f, cubeDef), PartPose.offset((float)0.0f, (float)0.0f, (float)-1.0f));
        spine.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(0, 13).addBox(-2.0f, -1.0f, -1.0f, 2.0f, 4.0f, 2.0f, cubeDef), PartPose.offset((float)-4.0f, (float)0.0f, (float)-2.0f));
        spine.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(29, 29).addBox(0.0f, -1.0f, -1.0f, 2.0f, 4.0f, 2.0f, cubeDef), PartPose.offset((float)4.0f, (float)0.0f, (float)-2.0f));
        spine.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(0, 0).addBox(-10.0f, -1.0f, -1.0f, 2.0f, 4.0f, 2.0f, cubeDef), PartPose.offset((float)4.0f, (float)0.0f, (float)3.0f));
        spine.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(0, 26).addBox(8.0f, -1.0f, -1.0f, 2.0f, 4.0f, 2.0f, cubeDef), PartPose.offset((float)-4.0f, (float)0.0f, (float)3.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)48, (int)48);
    }

    public void setupAnim(EntityRazorback entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180) / 2.0f;
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180) / 4.0f;
        float f1 = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        float f2 = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.body.zRot = f1 * 0.03f;
        this.rightHindLeg.xRot = this.leftFrontLeg.xRot = f1;
        this.leftHindLeg.xRot = this.rightFrontLeg.xRot = f2;
        this.tail.yRot = f1 * 0.2f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.spine.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

