/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.vanilla;

import com.mojang.serialization.MapCodec;
import divinerpg.block_entities.block.TerranGhostBlockEntity;
import divinerpg.registries.BlockEntityRegistry;
import divinerpg.registries.ItemRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TerranGhostBlock
extends BaseEntityBlock {
    public static final MapCodec<TerranGhostBlock> CODEC = TerranGhostBlock.simpleCodec(TerranGhostBlock::new);

    public TerranGhostBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public float getShadeBrightness(BlockState state, BlockGetter getter, BlockPos pos) {
        return 1.0f;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter getter, BlockPos pos) {
        return true;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)BlockEntityRegistry.TERRAN_GHOST.get()).create(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return TerranGhostBlock.createCrateTicker(level, type, (BlockEntityType<? extends TerranGhostBlockEntity>)((BlockEntityType)BlockEntityRegistry.TERRAN_GHOST.get()));
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createCrateTicker(Level level, BlockEntityType<T> type, BlockEntityType<? extends TerranGhostBlockEntity> entityType) {
        return level.isClientSide ? TerranGhostBlock.createTickerHelper(type, entityType, TerranGhostBlockEntity::clientTick) : TerranGhostBlock.createTickerHelper(type, entityType, TerranGhostBlockEntity::serverTick);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.is(newState.getBlock())) {
            if (level instanceof ServerLevel) {
                ServerLevel s = (ServerLevel)level;
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof TerranGhostBlockEntity) {
                    TerranGhostBlockEntity e = (TerranGhostBlockEntity)blockEntity;
                    if (e.originalState != null && e.originalState != newState) {
                        List drops = e.originalState.getDrops(new LootParams.Builder(s).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)ItemRegistry.terran_shickaxe.toStack()));
                        for (ItemStack drop : drops) {
                            if (drop.isEmpty()) continue;
                            ItemEntity itemEntity = new ItemEntity((Level)s, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, drop);
                            itemEntity.setDeltaMovement(0.0, 0.1, 0.0);
                            s.addFreshEntity((Entity)itemEntity);
                        }
                    }
                }
            }
            level.removeBlockEntity(pos);
        }
    }
}

