/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.vanilla;

import divinerpg.blocks.vanilla.MinerBlock;
import divinerpg.registries.ItemRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class SoftMinerBlock
extends MinerBlock {
    @Override
    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos p, boolean b) {
        if (level instanceof ServerLevel) {
            ServerLevel s = (ServerLevel)level;
            boolean hasSignal = level.hasNeighborSignal(pos) || level.hasNeighborSignal(pos.above());
            boolean triggered = (Boolean)state.getValue((Property)BlockStateProperties.TRIGGERED);
            if (triggered && !hasSignal) {
                level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.TRIGGERED, (Comparable)Boolean.valueOf(false)), 4);
            } else if (hasSignal && !triggered) {
                level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.TRIGGERED, (Comparable)Boolean.valueOf(true)), 4);
                p = pos.relative((Direction)state.getValue((Property)BlockStateProperties.FACING));
                BlockState blockState = level.getBlockState(p);
                if (!s.getBlockState(p).is(BlockTags.WITHER_IMMUNE)) {
                    ItemStack tool = ItemRegistry.divine_shickaxe.toStack();
                    tool.enchant((Holder)s.holderLookup(Registries.ENCHANTMENT).getOrThrow(Enchantments.SILK_TOUCH), 1);
                    List drops = blockState.getDrops(new LootParams.Builder(s).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)tool));
                    level.destroyBlock(p, false);
                    for (ItemStack drop : drops) {
                        if (drop.isEmpty()) continue;
                        ItemEntity itemEntity = new ItemEntity((Level)s, (double)p.getX() + 0.5, (double)p.getY() + 0.5, (double)p.getZ() + 0.5, drop);
                        itemEntity.setDeltaMovement(0.0, 0.1, 0.0);
                        s.addFreshEntity((Entity)itemEntity);
                    }
                }
            }
        }
    }
}

