/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.vanilla;

import com.mojang.authlib.GameProfile;
import divinerpg.blocks.vanilla.MinerBlock;
import divinerpg.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;

public class PlacerBlock
extends MinerBlock {
    @Override
    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos p, boolean b) {
        if (level instanceof ServerLevel) {
            ServerLevel s = (ServerLevel)level;
            boolean hasSignal = level.hasNeighborSignal(pos) || level.hasNeighborSignal(pos.above());
            boolean triggered = (Boolean)state.getValue((Property)BlockStateProperties.TRIGGERED);
            if (triggered && !hasSignal) {
                level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.TRIGGERED, (Comparable)Boolean.valueOf(false)), 4);
            } else if (hasSignal && !triggered) {
                BlockEntity blockEntity;
                level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.TRIGGERED, (Comparable)Boolean.valueOf(true)), 4);
                Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
                p = pos.relative(facing);
                if (level.getBlockState(p).isAir() && (blockEntity = s.getBlockEntity(pos.relative(facing.getOpposite()))) instanceof Container) {
                    Container c = (Container)blockEntity;
                    for (int i = 0; i < c.getContainerSize(); ++i) {
                        Item item;
                        ItemStack stack = c.getItem(i).copyWithCount(1);
                        if (!c.canTakeItem(Utils.EMPTY_CONTAINER, i, stack) || !((item = stack.getItem()) instanceof BlockItem)) continue;
                        BlockItem v = (BlockItem)item;
                        FakePlayer fp = FakePlayerFactory.get((ServerLevel)s, (GameProfile)Utils.FAKE_PLAYER);
                        float fl = facing.toYRot();
                        fp.setPos(Vec3.atCenterOf((Vec3i)pos));
                        fp.yRotO = fl;
                        fp.setYRot(fp.yRotO);
                        fp.yBodyRotO = fl;
                        fp.setYBodyRot(fp.yBodyRotO);
                        fp.yHeadRotO = fl;
                        fp.setYHeadRot(fp.yHeadRotO);
                        fp.yRotO = facing == Direction.UP ? -90.0f : (facing == Direction.DOWN ? 90.0f : 0.0f);
                        fp.setXRot(fp.yRotO);
                        v.place(new BlockPlaceContext((Level)s, (Player)fp, InteractionHand.MAIN_HAND, stack, new BlockHitResult(Vec3.atCenterOf((Vec3i)pos), facing, p, false)));
                        c.removeItem(i, 1);
                        break;
                    }
                }
            }
        }
    }
}

