/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.vanilla;

import com.mojang.serialization.MapCodec;
import divinerpg.block_entities.AltarOfCorruptionBlockEntity;
import divinerpg.client.menu.AltarOfCorruptionMenu;
import divinerpg.registries.BlockEntityRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockAltarOfCorruption
extends BaseEntityBlock {
    public static final MapCodec<BlockAltarOfCorruption> CODEC = BlockAltarOfCorruption.simpleCodec(BlockAltarOfCorruption::new);
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    public static final List<BlockPos> BOOKSHELF_OFFSETS = BlockPos.betweenClosedStream((int)-2, (int)0, (int)-2, (int)2, (int)1, (int)2).filter(p_341357_ -> Math.abs(p_341357_.getX()) == 2 || Math.abs(p_341357_.getZ()) == 2).map(BlockPos::immutable).toList();

    public MapCodec<BlockAltarOfCorruption> codec() {
        return CODEC;
    }

    public BlockAltarOfCorruption(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.COLOR_PURPLE));
    }

    public static boolean isValidBookShelf(Level level, BlockPos enchantingTablePos, BlockPos bookshelfPos) {
        return true;
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        for (BlockPos blockpos : BOOKSHELF_OFFSETS) {
            if (random.nextInt(16) != 0 || !BlockAltarOfCorruption.isValidBookShelf(level, pos, blockpos)) continue;
            level.addParticle((ParticleOptions)ParticleTypes.ENCHANT, (double)pos.getX() + 0.5, (double)pos.getY() + 2.0, (double)pos.getZ() + 0.5, (double)((float)blockpos.getX() + random.nextFloat()) - 0.5, (double)((float)blockpos.getY() - random.nextFloat() - 1.0f), (double)((float)blockpos.getZ() + random.nextFloat()) - 0.5);
        }
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AltarOfCorruptionBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? BlockAltarOfCorruption.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)BlockEntityRegistry.ALTAR_OF_CORRUPTION.get()), AltarOfCorruptionBlockEntity::bookAnimationTick) : null;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        player.openMenu(state.getMenuProvider(level, pos));
        return InteractionResult.CONSUME;
    }

    @Nullable
    protected MenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof AltarOfCorruptionBlockEntity) {
            Component component = ((Nameable)blockentity).getDisplayName();
            return new SimpleMenuProvider((p_341299_, p_341308_, p_341334_) -> new AltarOfCorruptionMenu(p_341299_, p_341308_, ContainerLevelAccess.create((Level)level, (BlockPos)pos)), component);
        }
        return null;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

