/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.iceika;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.ticks.TickPriority;
import org.jetbrains.annotations.Nullable;

public class RedstoneBooster
extends DiodeBlock {
    public static final MapCodec<RedstoneBooster> CODEC = RedstoneBooster.simpleCodec(RedstoneBooster::new);

    public RedstoneBooster(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.POWER, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWERED, BlockStateProperties.POWER});
    }

    protected MapCodec<? extends DiodeBlock> codec() {
        return CODEC;
    }

    protected int getDelay(BlockState blockState) {
        return 2;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return true;
    }

    protected int getSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return blockState.getValue((Property)FACING) == side ? (Integer)blockState.getValue((Property)BlockStateProperties.POWER) : 0;
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int power = RedstoneBooster.getCombinedInputSignal((Level)level, pos, (Direction)state.getValue((Property)FACING)) & 0xF;
        if (power != (Integer)state.getValue((Property)BlockStateProperties.POWER)) {
            level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)BlockStateProperties.POWER, (Comparable)Integer.valueOf(power))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(power > 0)), 3);
        }
    }

    protected boolean shouldTurnOn(Level level, BlockPos pos, BlockState state) {
        return this.getInputSignal(level, pos, state) > 0 || this.getAlternateSignal((SignalGetter)level, pos, state) > 0;
    }

    public static int getCombinedInputSignal(Level level, BlockPos pos, Direction facing) {
        return level.getSignal(pos.relative(facing), facing) + level.getSignal(pos.relative(facing.getClockWise()), facing.getClockWise()) + level.getSignal(pos.relative(facing.getCounterClockWise()), facing.getCounterClockWise());
    }

    protected void checkTickOnNeighbor(Level level, BlockPos pos, BlockState state) {
        if (!level.getBlockTicks().willTickThisTick(pos, (Object)this)) {
            TickPriority tickpriority = TickPriority.HIGH;
            if (this.shouldPrioritize((BlockGetter)level, pos, state)) {
                tickpriority = TickPriority.EXTREMELY_HIGH;
            } else if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
                tickpriority = TickPriority.VERY_HIGH;
            }
            level.scheduleTick(pos, (Block)this, 2, tickpriority);
        }
    }
}

