/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.iceika;

import com.mojang.serialization.MapCodec;
import divinerpg.block_entities.block.RobbinNestBlockEntity;
import divinerpg.registries.BlockEntityRegistry;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.ItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockRobbinNest
extends BaseEntityBlock {
    public static final MapCodec<BlockRobbinNest> CODEC = BlockRobbinNest.simpleCodec(BlockRobbinNest::new);
    protected static final VoxelShape BASE_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);

    public MapCodec<BlockRobbinNest> codec() {
        return CODEC;
    }

    public BlockRobbinNest(BlockBehaviour.Properties properties) {
        super(properties.randomTicks().noOcclusion().mapColor(MapColor.COLOR_BROWN).isSuffocating((state, getter, pos) -> false).isViewBlocking((state, getter, pos) -> false).pushReaction(PushReaction.DESTROY).isRedstoneConductor((state, getter, pos) -> false));
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return BASE_SHAPE;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntityRegistry.ROBBIN_NEST.get()).create(pos, state);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        RobbinNestBlockEntity block;
        BlockEntity blockEntity;
        if (state.is((Block)this) && random.nextBoolean() && (blockEntity = level.getBlockEntity(pos)) instanceof RobbinNestBlockEntity && (block = (RobbinNestBlockEntity)blockEntity).getItem().is((Item)ItemRegistry.robbin_egg.get())) {
            block.removeItem(0, 1);
            ((EntityType)EntityRegistry.ROBBIN.get()).spawn(level, pos, MobSpawnType.BREEDING);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(pos));
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof RobbinNestBlockEntity) {
            RobbinNestBlockEntity block = (RobbinNestBlockEntity)blockEntity;
            if (stack == null || stack.isEmpty()) {
                if (!block.getItem().isEmpty()) {
                    player.setItemInHand(hand, block.getItem());
                    block.setItemSilent(ItemStack.EMPTY);
                    return ItemInteractionResult.SUCCESS;
                }
                return ItemInteractionResult.FAIL;
            }
            if (block.getItem().isEmpty()) {
                block.setItemSilent(stack.copy());
                if (!player.isCreative()) {
                    player.setItemInHand(hand, ItemStack.EMPTY);
                }
                return ItemInteractionResult.SUCCESS;
            }
            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5, block.getItem()));
            block.setItemSilent(ItemStack.EMPTY);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState s, boolean b) {
        if (!state.is(s.getBlock()) || !s.hasBlockEntity()) {
            RobbinNestBlockEntity block;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof RobbinNestBlockEntity && !(block = (RobbinNestBlockEntity)blockEntity).isEmpty()) {
                Containers.dropContents((Level)level, (BlockPos)pos, (Container)block);
            }
            level.removeBlockEntity(pos);
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof RobbinNestBlockEntity) {
            RobbinNestBlockEntity block = (RobbinNestBlockEntity)blockEntity;
            if (!block.isEmpty()) {
                Containers.dropContents((Level)level, (BlockPos)pos, (Container)block);
            }
            level.removeBlockEntity(pos);
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }
}

