/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.iceika;

import com.mojang.serialization.MapCodec;
import divinerpg.block_entities.block.RobbinHutBlockEntity;
import divinerpg.entities.iceika.EntityRobbin;
import divinerpg.registries.BlockEntityRegistry;
import divinerpg.registries.EntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockRobbinHut
extends BaseEntityBlock {
    public static final MapCodec<BlockRobbinHut> CODEC = BlockRobbinHut.simpleCodec(BlockRobbinHut::new);
    protected static final VoxelShape BASE_SHAPE = BlockRobbinHut.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public MapCodec<BlockRobbinHut> codec() {
        return CODEC;
    }

    public BlockRobbinHut(BlockBehaviour.Properties properties) {
        super(properties.randomTicks().mapColor(MapColor.COLOR_LIGHT_GRAY).isSuffocating((state, getter, pos) -> false).isViewBlocking((state, getter, pos) -> false).isRedstoneConductor((state, getter, pos) -> false));
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return BASE_SHAPE;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof RobbinHutBlockEntity) {
            RobbinHutBlockEntity block = (RobbinHutBlockEntity)blockEntity;
            if ((block.robbin1 != null || block.robbin2 != null) && level.getBlockState(pos = pos.offset(((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)).getNormal())).isAir()) {
                if (block.robbin2 == null) {
                    ((EntityType)EntityRegistry.ROBBIN.get()).spawn(level, en -> en.load(block.robbin1), pos, MobSpawnType.DISPENSER, true, true);
                    block.robbin1 = null;
                } else {
                    ((EntityRobbin)((EntityType)EntityRegistry.ROBBIN.get()).spawn((ServerLevel)level, null, (BlockPos)pos, (MobSpawnType)MobSpawnType.DISPENSER, (boolean)true, (boolean)true)).wantsNest = block.robbin1 != null;
                    block.robbin2 = null;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasSpace(ServerLevel level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof RobbinHutBlockEntity)) return false;
        RobbinHutBlockEntity block = (RobbinHutBlockEntity)blockEntity;
        if (block.robbin1 == null) return true;
        if (block.robbin2 != null) return false;
        return true;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntityRegistry.ROBBIN_HUT.get()).create(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HorizontalDirectionalBlock.FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mir) {
        return state.rotate(mir.getRotation((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)));
    }
}

