/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.iceika;

import divinerpg.blocks.base.BlockMod;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlockGraveStone
extends BlockMod {
    public static final VoxelShape SHAPEZ = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)2.0, (double)13.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)5.0, (double)16.0, (double)15.0, (double)11.0));
    public static final VoxelShape SHAPEX = Shapes.or((VoxelShape)Block.box((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)5.0, (double)2.0, (double)0.0, (double)11.0, (double)15.0, (double)16.0));

    public BlockGraveStone() {
        super(BlockBehaviour.Properties.of().strength(2.0f, 6.0f).sound(SoundType.STONE).mapColor(MapColor.ICE));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
        return direction.getAxis() == Direction.Axis.X ? SHAPEX : SHAPEZ;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HorizontalDirectionalBlock.FACING});
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        super.playerDestroy(level, player, pos, state, blockEntity, tool);
        if (level instanceof ServerLevel) {
            ServerLevel s = (ServerLevel)level;
            if (!EnchantmentHelper.hasTag((ItemStack)tool, (TagKey)EnchantmentTags.PREVENTS_BEE_SPAWNS_WHEN_MINING)) {
                if (s.getDifficulty() != Difficulty.PEACEFUL) {
                    EntityType type = (EntityType)EntityRegistry.FROZEN_FLESH.get();
                    Utils.summonEntityAt(s, type, pos.offset(3, 0, 0), player);
                    Utils.summonEntityAt(s, type, pos.offset(1, 0, 2), player);
                    Utils.summonEntityAt(s, type, pos.offset(-1, 0, 2), player);
                    Utils.summonEntityAt(s, type, pos.offset(-3, 0, 0), player);
                    Utils.summonEntityAt(s, type, pos.offset(1, 0, -2), player);
                    Utils.summonEntityAt(s, type, pos.offset(-1, 0, -2), player);
                }
                level.playSound(null, pos, (SoundEvent)SoundRegistry.FREEZE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                level.playSound(null, pos, SoundEvents.SCULK_SHRIEKER_SHRIEK, SoundSource.BLOCKS, 0.6f, 1.5f);
            }
        }
    }
}

