/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.iceika;

import divinerpg.blocks.base.BlockModMoss;
import divinerpg.registries.BlockRegistry;
import divinerpg.world.ConfiguredFeatureKeys;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.material.MapColor;

public class BlockBrittleMoss
extends BlockModMoss {
    public BlockBrittleMoss() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MOSS_BLOCK).mapColor(MapColor.GLOW_LICHEN));
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return level.getBlockState(pos.below()).isAir() || level.getBlockState(pos.above()).isAir();
    }

    @Override
    public void place(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockState s;
        if (random.nextBoolean()) {
            pos = pos.relative(Direction.getRandom((RandomSource)random));
        }
        if ((s = level.getBlockState(pos)).is(BlockTags.MOSS_REPLACEABLE) || s.is(BlockTags.SNOW)) {
            if (s.is((Block)BlockRegistry.brittleMoss.get())) {
                ((ConfiguredFeature)ConfiguredFeatureKeys.getConfiguredFeature((WorldGenLevel)level, ConfiguredFeatureKeys.BRITTLE_PLANTS).value()).place((WorldGenLevel)level, null, random, pos);
            } else {
                level.setBlock(pos, state, 3);
            }
        }
    }
}

