/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.base;

import com.mojang.serialization.MapCodec;
import divinerpg.block_entities.block.ProximitySpawnerBlockEntity;
import divinerpg.registries.BlockEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class BlockModProximitySpawner
extends BaseEntityBlock {
    public static final MapCodec<BlockModProximitySpawner> CODEC = BlockModProximitySpawner.simpleCodec(BlockModProximitySpawner::new);

    public MapCodec<BlockModProximitySpawner> codec() {
        return CODEC;
    }

    public BlockModProximitySpawner(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.ENABLED});
    }

    public BlockState updateShape(BlockState state, Direction dir, BlockState s, LevelAccessor level, BlockPos pos, BlockPos p) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ProximitySpawnerBlockEntity) {
            boolean enabled;
            ProximitySpawnerBlockEntity spawner = (ProximitySpawnerBlockEntity)blockEntity;
            boolean bl = enabled = spawner.entityName != null;
            if ((Boolean)state.getValue((Property)BlockStateProperties.ENABLED) != enabled) {
                state.setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(enabled));
            }
        }
        return state;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity;
        if (player.isCreative() && (blockEntity = level.getBlockEntity(pos)) instanceof ProximitySpawnerBlockEntity) {
            boolean enabled;
            ProximitySpawnerBlockEntity entity = (ProximitySpawnerBlockEntity)blockEntity;
            if (stack == null || stack.isEmpty()) {
                entity.entityName = null;
            } else {
                Item item = stack.getItem();
                if (item instanceof SpawnEggItem) {
                    SpawnEggItem spawnegg = (SpawnEggItem)item;
                    entity.entityName = spawnegg.getType(stack).getDescriptionId().substring(7).replace('.', ':');
                } else {
                    return ItemInteractionResult.FAIL;
                }
            }
            boolean bl = enabled = entity.entityName != null;
            if ((Boolean)state.getValue((Property)BlockStateProperties.ENABLED) != enabled) {
                level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(enabled)), 3);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntityRegistry.PROXIMITY_SPAWNER.get()).create(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : BlockModProximitySpawner.createTickerHelper(type, (BlockEntityType)((BlockEntityType)BlockEntityRegistry.PROXIMITY_SPAWNER.get()), ProximitySpawnerBlockEntity::serverTick);
    }
}

