/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.base;

import divinerpg.blocks.base.BlockMod;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockModPowered
extends BlockMod {
    public static final BooleanProperty POWERED = BooleanProperty.create((String)"powered");

    public BlockModPowered(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED});
    }

    public void onPlace(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.handleBlockState(state, worldIn, pos);
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.handleBlockState(state, worldIn, pos);
        DebugPackets.sendNeighborsUpdatePacket((Level)worldIn, (BlockPos)pos);
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        this.handleBlockState(state, (Level)worldIn, pos);
    }

    public void handleBlockState(BlockState state, Level worldIn, BlockPos pos) {
        if (!worldIn.isClientSide) {
            if (((Boolean)state.getValue((Property)POWERED)).booleanValue() && !worldIn.hasNeighborSignal(pos)) {
                worldIn.setBlock(pos, this.defaultBlockState(), 2);
            } else if (!((Boolean)state.getValue((Property)POWERED)).booleanValue() && worldIn.hasNeighborSignal(pos)) {
                worldIn.setBlock(pos, (BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
    }
}

