/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.arcana;

import divinerpg.block_entities.furnace.ArcaniumExtractorBlockEntity;
import divinerpg.registries.BlockEntityRegistry;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockArcaniumExtractor
extends FurnaceBlock {
    private static VoxelShape CUSTOM_SHAPE = null;

    public BlockArcaniumExtractor() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_BLUE).strength(-1.0f, 3600000.0f).instrument(NoteBlockInstrument.BASEDRUM).noOcclusion().dynamicShape());
        ArrayList<VoxelShape> parts = new ArrayList<VoxelShape>();
        parts.add(Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.125, (double)0.9375));
        parts.add(Shapes.box((double)0.0625, (double)0.625, (double)0.0625, (double)0.9375, (double)0.75, (double)0.9375));
        parts.add(Shapes.box((double)0.0625, (double)1.25, (double)0.0625, (double)0.9375, (double)1.375, (double)0.9375));
        parts.add(Shapes.box((double)0.6875, (double)0.75, (double)0.6875, (double)0.8125, (double)1.25, (double)0.8125));
        parts.add(Shapes.box((double)0.6875, (double)0.75, (double)0.1875, (double)0.8125, (double)1.25, (double)0.3125));
        parts.add(Shapes.box((double)0.1875, (double)0.75, (double)0.1875, (double)0.3125, (double)1.25, (double)0.3125));
        parts.add(Shapes.box((double)0.1875, (double)0.75, (double)0.6875, (double)0.3125, (double)1.25, (double)0.8125));
        parts.add(Shapes.box((double)0.625, (double)0.125, (double)0.625, (double)0.75, (double)0.625, (double)0.75));
        parts.add(Shapes.box((double)0.625, (double)0.125, (double)0.25, (double)0.75, (double)0.625, (double)0.375));
        parts.add(Shapes.box((double)0.25, (double)0.125, (double)0.25, (double)0.375, (double)0.625, (double)0.375));
        parts.add(Shapes.box((double)0.25, (double)0.125, (double)0.625, (double)0.375, (double)0.625, (double)0.75));
        CUSTOM_SHAPE = parts.stream().reduce(Shapes::or).orElse(Shapes.block());
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return CUSTOM_SHAPE;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    protected void openContainer(Level world, BlockPos pos, Player player) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof ArcaniumExtractorBlockEntity) {
            player.openMenu((MenuProvider)blockEntity);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntityRegistry.ARCANIUM_EXTRACTOR.get()).create(pos, state);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof ArcaniumExtractorBlockEntity) {
                ArcaniumExtractorBlockEntity extractor = (ArcaniumExtractorBlockEntity)blockEntity;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)extractor);
                extractor.getRecipesToAwardAndPopExperience((ServerLevel)world, Vec3.atCenterOf((Vec3i)pos));
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockArcaniumExtractor.createFurnaceTicker(type, level);
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createFurnaceTicker(BlockEntityType<T> blockEntityType, Level level) {
        return level.isClientSide ? null : BlockArcaniumExtractor.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)BlockEntityRegistry.ARCANIUM_EXTRACTOR.get()), AbstractFurnaceBlockEntity::serverTick);
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
    }
}

