/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.block_entities.furnace;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public abstract class ModFurnaceBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeCraftingHolder,
StackedContentsCompatible {
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    public final RecipeManager.CachedCheck<SingleRecipeInput, ? extends AbstractCookingRecipe> quickCheck = RecipeManager.createCheck((RecipeType)RecipeType.SMELTING);
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    protected NonNullList<ItemStack> items = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
    public final String containerName;
    public final double speed;
    int litTime;
    int litDuration;
    int cookingProgress;
    int cookingTotalTime;
    protected final ContainerData dataAccess = new ContainerData(){

        public int get(int p_58431_) {
            return switch (p_58431_) {
                case 0 -> ModFurnaceBlockEntity.this.litTime;
                case 1 -> ModFurnaceBlockEntity.this.litDuration;
                case 2 -> ModFurnaceBlockEntity.this.cookingProgress;
                case 3 -> ModFurnaceBlockEntity.this.cookingTotalTime;
                default -> 0;
            };
        }

        public void set(int p_58433_, int p_58434_) {
            switch (p_58433_) {
                case 0: {
                    ModFurnaceBlockEntity.this.litTime = p_58434_;
                    break;
                }
                case 1: {
                    ModFurnaceBlockEntity.this.litDuration = p_58434_;
                    break;
                }
                case 2: {
                    ModFurnaceBlockEntity.this.cookingProgress = p_58434_;
                    break;
                }
                case 3: {
                    ModFurnaceBlockEntity.this.cookingTotalTime = p_58434_;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };

    public ModFurnaceBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, String containerName, double speed) {
        super(type, pos, state);
        this.containerName = containerName;
        this.speed = speed;
    }

    protected Component getDefaultName() {
        return Component.translatable((String)this.containerName);
    }

    protected int getBurnDuration(ItemStack stack) {
        if (stack.isEmpty()) {
            return 0;
        }
        return (int)((double)stack.getBurnTime(RecipeType.SMELTING) / this.speed);
    }

    public static int getTotalCookTime(Level level, ModFurnaceBlockEntity tile) {
        return (int)((double)tile.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(tile.getItem(0)), level).map(mapper -> ((AbstractCookingRecipe)mapper.value()).getCookingTime()).orElse(200).intValue() / tile.speed);
    }

    public boolean isLit() {
        return this.litTime > 0;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        this.litTime = tag.getInt("BurnTime");
        this.cookingProgress = tag.getInt("CookTime");
        this.cookingTotalTime = tag.getInt("CookTimeTotal");
        this.litDuration = this.getBurnDuration((ItemStack)this.items.get(1));
        CompoundTag compoundtag = tag.getCompound("RecipesUsed");
        for (String s : compoundtag.getAllKeys()) {
            this.recipesUsed.put((Object)ResourceLocation.parse((String)s), compoundtag.getInt(s));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("BurnTime", this.litTime);
        tag.putInt("CookTime", this.cookingProgress);
        tag.putInt("CookTimeTotal", this.cookingTotalTime);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        CompoundTag compoundtag = new CompoundTag();
        this.recipesUsed.forEach((p_187449_, p_187450_) -> compoundtag.putInt(p_187449_.toString(), p_187450_.intValue()));
        tag.put("RecipesUsed", (Tag)compoundtag);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ModFurnaceBlockEntity block) {
        boolean flag3;
        boolean flag = block.isLit();
        boolean flag1 = false;
        if (block.isLit()) {
            --block.litTime;
        }
        ItemStack itemstack = (ItemStack)block.items.get(1);
        boolean flag2 = !((ItemStack)block.items.get(0)).isEmpty();
        boolean bl = flag3 = !itemstack.isEmpty();
        if (block.isLit() || flag3 && flag2) {
            RecipeHolder recipe = flag2 ? (RecipeHolder)block.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput((ItemStack)block.items.getFirst()), level).orElse(null) : null;
            int maxStackSize = block.getMaxStackSize();
            if (!block.isLit() && block.canBurn(level.registryAccess(), recipe, block.items, maxStackSize, block)) {
                block.litDuration = block.litTime = block.getBurnDuration(itemstack);
                if (block.isLit()) {
                    flag1 = true;
                    if (itemstack.hasCraftingRemainingItem()) {
                        block.items.set(1, (Object)itemstack.getCraftingRemainingItem());
                    } else if (flag3) {
                        itemstack.shrink(1);
                        if (itemstack.isEmpty()) {
                            block.items.set(1, (Object)itemstack.getCraftingRemainingItem());
                        }
                    }
                }
            }
            if (block.isLit() && block.canBurn(level.registryAccess(), recipe, block.items, maxStackSize, block)) {
                ++block.cookingProgress;
                if (block.cookingProgress == block.cookingTotalTime) {
                    block.cookingProgress = 0;
                    block.cookingTotalTime = ModFurnaceBlockEntity.getTotalCookTime(level, block);
                    if (block.burn(level.registryAccess(), recipe, block.items, maxStackSize, block)) {
                        block.setRecipeUsed(recipe);
                    }
                    flag1 = true;
                }
            } else {
                block.cookingProgress = 0;
            }
        } else if (!block.isLit() && block.cookingProgress > 0) {
            block.cookingProgress = Mth.clamp((int)(block.cookingProgress - 2), (int)0, (int)block.cookingTotalTime);
        }
        if (flag != block.isLit()) {
            flag1 = true;
            state = (BlockState)state.setValue((Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(block.isLit()));
            level.setBlock(pos, state, 3);
        }
        if (flag1) {
            ModFurnaceBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private boolean canBurn(RegistryAccess registryAccess, @Nullable RecipeHolder<?> recipe, NonNullList<ItemStack> inventory, int maxStackSize, ModFurnaceBlockEntity furnace) {
        if (!((ItemStack)inventory.getFirst()).isEmpty() && recipe != null) {
            ItemStack itemstack = ((AbstractCookingRecipe)recipe.value()).assemble(new SingleRecipeInput(furnace.getItem(0)), (HolderLookup.Provider)registryAccess);
            if (itemstack.isEmpty()) {
                return false;
            }
            ItemStack itemstack1 = (ItemStack)this.items.get(2);
            if (itemstack1.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)itemstack1, (ItemStack)itemstack)) {
                return false;
            }
            if (itemstack1.getCount() + itemstack.getCount() <= maxStackSize && itemstack1.getCount() + itemstack.getCount() <= itemstack1.getMaxStackSize()) {
                return true;
            }
            return itemstack1.getCount() + itemstack.getCount() <= itemstack.getMaxStackSize();
        }
        return false;
    }

    private boolean burn(RegistryAccess registryAccess, @Nullable RecipeHolder<?> recipe, NonNullList<ItemStack> inventory, int maxStackSize, ModFurnaceBlockEntity furnace) {
        if (recipe != null && this.canBurn(registryAccess, recipe, inventory, maxStackSize, furnace)) {
            ItemStack itemstack = (ItemStack)inventory.get(0);
            ItemStack itemstack1 = ((AbstractCookingRecipe)recipe.value()).assemble(new SingleRecipeInput(furnace.getItem(0)), (HolderLookup.Provider)registryAccess);
            ItemStack itemstack2 = (ItemStack)inventory.get(2);
            if (itemstack2.isEmpty()) {
                inventory.set(2, (Object)itemstack1.copy());
            } else if (ItemStack.isSameItemSameComponents((ItemStack)itemstack2, (ItemStack)itemstack1)) {
                itemstack2.grow(itemstack1.getCount());
            }
            if (itemstack.is(Blocks.WET_SPONGE.asItem()) && !((ItemStack)inventory.get(1)).isEmpty() && ((ItemStack)inventory.get(1)).is(Items.BUCKET)) {
                inventory.set(1, (Object)new ItemStack((ItemLike)Items.WATER_BUCKET));
            }
            itemstack.shrink(1);
            return true;
        }
        return false;
    }

    public int[] getSlotsForFace(Direction p_58363_) {
        if (p_58363_ == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return p_58363_ == Direction.UP ? SLOTS_FOR_UP : SLOTS_FOR_SIDES;
    }

    public boolean canPlaceItemThroughFace(int p_58336_, ItemStack p_58337_, @Nullable Direction p_58338_) {
        return this.canPlaceItem(p_58336_, p_58337_);
    }

    public boolean canTakeItemThroughFace(int p_58392_, ItemStack p_58393_, Direction p_58394_) {
        if (p_58394_ == Direction.DOWN && p_58392_ == 1) {
            return p_58393_.is(Items.WATER_BUCKET) || p_58393_.is(Items.BUCKET);
        }
        return true;
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    public ItemStack getItem(int p_58328_) {
        return (ItemStack)this.items.get(p_58328_);
    }

    public ItemStack removeItem(int p_58330_, int p_58331_) {
        return ContainerHelper.removeItem(this.items, (int)p_58330_, (int)p_58331_);
    }

    public ItemStack removeItemNoUpdate(int p_58387_) {
        return ContainerHelper.takeItem(this.items, (int)p_58387_);
    }

    public void setItem(int p_58333_, ItemStack p_58334_) {
        ItemStack itemstack = (ItemStack)this.items.get(p_58333_);
        boolean flag = !p_58334_.isEmpty() && ItemStack.isSameItem((ItemStack)p_58334_, (ItemStack)itemstack);
        this.items.set(p_58333_, (Object)p_58334_);
        if (p_58334_.getCount() > this.getMaxStackSize()) {
            p_58334_.setCount(this.getMaxStackSize());
        }
        if (p_58333_ == 0 && !flag) {
            this.cookingTotalTime = ModFurnaceBlockEntity.getTotalCookTime(this.level, this);
            this.cookingProgress = 0;
            this.setChanged();
        }
    }

    public boolean stillValid(Player p_58340_) {
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return p_58340_.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public boolean canPlaceItem(int p_58389_, ItemStack stack) {
        if (p_58389_ == 2) {
            return false;
        }
        if (p_58389_ != 1) {
            return true;
        }
        ItemStack itemstack = (ItemStack)this.items.get(1);
        return stack.getBurnTime(RecipeType.SMELTING) > 0 || stack.is(Items.BUCKET) && !itemstack.is(Items.BUCKET);
    }

    public void clearContent() {
        this.items.clear();
    }

    public void setRecipeUsed(RecipeHolder<?> recipe) {
        if (recipe != null) {
            this.recipesUsed.addTo((Object)recipe.id(), 1);
        }
    }

    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public void awardUsedRecipes(Player p_281647_, List<ItemStack> p_282578_) {
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer player) {
        List<RecipeHolder<?>> list = this.getRecipesToAwardAndPopExperience(player.serverLevel(), player.position());
        player.awardRecipes(list);
        for (RecipeHolder<?> recipeholder : list) {
            if (recipeholder == null) continue;
            player.triggerRecipeCrafted(recipeholder, this.items);
        }
        this.recipesUsed.clear();
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(ServerLevel level, Vec3 position) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            level.getRecipeManager().byKey((ResourceLocation)entry.getKey()).ifPresent(p_300839_ -> {
                list.add(p_300839_);
                ModFurnaceBlockEntity.createExperience(level, position, entry.getIntValue(), ((AbstractCookingRecipe)p_300839_.value()).getExperience());
            });
        }
        return list;
    }

    private static void createExperience(ServerLevel level, Vec3 position, int entry, float amount) {
        int xpAmount = Mth.floor((float)((float)entry * amount));
        float xpFraction = Mth.frac((float)((float)entry * amount));
        if (xpFraction != 0.0f && Math.random() < (double)xpFraction) {
            ++xpAmount;
        }
        ExperienceOrb.award((ServerLevel)level, (Vec3)position, (int)xpAmount);
    }

    public void fillStackedContents(StackedContents p_58342_) {
        for (ItemStack itemstack : this.items) {
            p_58342_.accountStack(itemstack);
        }
    }
}

