/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.block_entities.furnace;

import com.google.common.collect.Lists;
import divinerpg.block_entities.furnace.CoalstoneFurnaceBlockEntity;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public abstract class InfiniFurnaceBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeCraftingHolder,
StackedContentsCompatible {
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{1};
    public final RecipeManager.CachedCheck<SingleRecipeInput, ? extends AbstractCookingRecipe> quickCheck = RecipeManager.createCheck((RecipeType)RecipeType.SMELTING);
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    protected NonNullList<ItemStack> items = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    int cookingTotalTime;
    int cookingProgress;
    protected final ContainerData dataAccess = new ContainerData(){

        public int get(int type) {
            return type == 0 ? InfiniFurnaceBlockEntity.this.cookingProgress : InfiniFurnaceBlockEntity.this.cookingTotalTime;
        }

        public void set(int type, int value) {
            if (type == 0) {
                InfiniFurnaceBlockEntity.this.cookingProgress = value;
            } else {
                InfiniFurnaceBlockEntity.this.cookingTotalTime = value;
            }
        }

        public int getCount() {
            return 2;
        }
    };
    public final String containerName;
    public final double speed;
    public boolean isLit = false;

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    protected InfiniFurnaceBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, String containerName, double speed) {
        super(type, pos, state);
        this.containerName = containerName;
        this.speed = speed;
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public void clearContent() {
        this.items.clear();
    }

    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public void setRecipeUsed(RecipeHolder<?> recipe) {
        if (recipe != null) {
            this.recipesUsed.addTo((Object)recipe.id(), 1);
        }
    }

    public boolean canPlaceItemThroughFace(int i, ItemStack stack, Direction direction) {
        return this.canPlaceItem(i, stack);
    }

    public boolean canTakeItemThroughFace(int i, ItemStack stack, Direction direction) {
        return true;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return slot != 1;
    }

    public void awardUsedRecipes(Player p_281647_, List<ItemStack> p_282578_) {
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack removeItem(int i, int j) {
        return ContainerHelper.removeItem(this.items, (int)i, (int)j);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.items, (int)slot);
    }

    public void setItem(int slot, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.items.get(slot);
        boolean flag = !stack.isEmpty() && ItemStack.isSameItem((ItemStack)stack, (ItemStack)itemstack);
        this.items.set(slot, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        if (slot == 0 && !flag) {
            this.cookingTotalTime = InfiniFurnaceBlockEntity.getTotalCookTime(this.level, this);
            this.cookingProgress = 0;
            this.setChanged();
        }
    }

    public static int getTotalCookTime(Level level, InfiniFurnaceBlockEntity tile) {
        return (int)((double)tile.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(tile.getItem(0)), level).map(mapper -> ((AbstractCookingRecipe)mapper.value()).getCookingTime()).orElse(200).intValue() / tile.speed);
    }

    public boolean stillValid(Player player) {
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public void fillStackedContents(StackedContents contents) {
        for (ItemStack itemstack : this.items) {
            contents.accountStack(itemstack);
        }
    }

    public int[] getSlotsForFace(Direction direction) {
        return direction == Direction.DOWN ? SLOTS_FOR_DOWN : SLOTS_FOR_UP;
    }

    protected Component getDefaultName() {
        return Component.translatable((String)this.containerName);
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer player) {
        List<RecipeHolder<?>> list = this.getRecipesToAwardAndPopExperience(player.serverLevel(), player.position());
        player.awardRecipes(list);
        for (RecipeHolder<?> recipeholder : list) {
            if (recipeholder == null) continue;
            player.triggerRecipeCrafted(recipeholder, this.items);
        }
        this.recipesUsed.clear();
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(ServerLevel level, Vec3 position) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            level.getRecipeManager().byKey((ResourceLocation)entry.getKey()).ifPresent(p_300839_ -> {
                list.add(p_300839_);
                InfiniFurnaceBlockEntity.createExperience(level, position, entry.getIntValue(), ((AbstractCookingRecipe)p_300839_.value()).getExperience());
            });
        }
        return list;
    }

    private static void createExperience(ServerLevel level, Vec3 position, int entry, float amount) {
        int xpAmount = Mth.floor((float)((float)entry * amount));
        float xpFraction = Mth.frac((float)((float)entry * amount));
        if (xpFraction != 0.0f && Math.random() < (double)xpFraction) {
            ++xpAmount;
        }
        ExperienceOrb.award((ServerLevel)level, (Vec3)position, (int)xpAmount);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, InfiniFurnaceBlockEntity block) {
        boolean changes = false;
        RecipeHolder recipe = block.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput((ItemStack)block.items.getFirst()), level).orElse(null);
        int maxStackSize = block.getMaxStackSize();
        if (block.isLit) {
            if (block.canBurn(level.registryAccess(), recipe, block.items, maxStackSize, block)) {
                ++block.cookingProgress;
                if (block.cookingProgress >= block.cookingTotalTime) {
                    block.cookingProgress = 0;
                    block.cookingTotalTime = InfiniFurnaceBlockEntity.getTotalCookTime(level, block);
                    if (block.burn(level.registryAccess(), recipe, block.items, maxStackSize, block)) {
                        block.setRecipeUsed(recipe);
                    }
                }
            } else {
                block.isLit = false;
                changes = true;
            }
        } else if (block.canLight(level.registryAccess(), recipe, block.items, maxStackSize, block)) {
            block.isLit = true;
            changes = true;
        } else if (block.cookingProgress > 0) {
            block.cookingProgress = Mth.clamp((int)(block.cookingProgress - 2), (int)0, (int)block.cookingTotalTime);
        }
        if (block instanceof CoalstoneFurnaceBlockEntity && !block.isLit && level.getBlockState(pos.relative(((Direction)state.getValue((Property)AbstractFurnaceBlock.FACING)).getOpposite())).is(Blocks.MAGMA_BLOCK)) {
            block.isLit = true;
            changes = true;
        }
        if (changes) {
            state = (BlockState)state.setValue((Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(block.isLit));
            level.setBlock(pos, state, 3);
            InfiniFurnaceBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public boolean canLight(RegistryAccess registryAccess, @Nullable RecipeHolder<?> recipe, NonNullList<ItemStack> inventory, int maxStackSize, InfiniFurnaceBlockEntity furnace) {
        return !((ItemStack)inventory.getFirst()).isEmpty() && this.canBurn(registryAccess, recipe, inventory, maxStackSize, furnace);
    }

    private boolean canBurn(RegistryAccess registryAccess, @Nullable RecipeHolder<?> recipe, NonNullList<ItemStack> inventory, int maxStackSize, InfiniFurnaceBlockEntity furnace) {
        if (!((ItemStack)inventory.getFirst()).isEmpty() && recipe != null) {
            ItemStack itemstack = ((AbstractCookingRecipe)recipe.value()).assemble(new SingleRecipeInput(furnace.getItem(0)), (HolderLookup.Provider)registryAccess);
            if (itemstack.isEmpty()) {
                return false;
            }
            ItemStack itemstack1 = (ItemStack)this.items.get(1);
            if (itemstack1.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)itemstack1, (ItemStack)itemstack)) {
                return false;
            }
            if (itemstack1.getCount() + itemstack.getCount() <= maxStackSize && itemstack1.getCount() + itemstack.getCount() <= itemstack1.getMaxStackSize()) {
                return true;
            }
            return itemstack1.getCount() + itemstack.getCount() <= itemstack.getMaxStackSize();
        }
        return false;
    }

    private boolean burn(RegistryAccess registryAccess, @Nullable RecipeHolder<?> recipe, NonNullList<ItemStack> inventory, int maxStackSize, InfiniFurnaceBlockEntity furnace) {
        if (recipe != null && this.canBurn(registryAccess, recipe, inventory, maxStackSize, furnace)) {
            ItemStack itemstack = (ItemStack)this.items.get(0);
            ItemStack itemstack1 = ((AbstractCookingRecipe)recipe.value()).assemble(new SingleRecipeInput(furnace.getItem(0)), (HolderLookup.Provider)registryAccess);
            ItemStack itemstack2 = (ItemStack)this.items.get(1);
            if (itemstack2.isEmpty()) {
                this.items.set(1, (Object)itemstack1.copy());
            } else if (itemstack2.is(itemstack1.getItem())) {
                itemstack2.grow(itemstack1.getCount());
            }
            itemstack.shrink(1);
            return true;
        }
        return false;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        this.cookingProgress = tag.getInt("CookTime");
        this.cookingTotalTime = tag.getInt("CookTimeTotal");
        CompoundTag compoundtag = tag.getCompound("RecipesUsed");
        for (String s : compoundtag.getAllKeys()) {
            this.recipesUsed.put((Object)ResourceLocation.parse((String)s), compoundtag.getInt(s));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("CookTime", this.cookingProgress);
        tag.putInt("CookTimeTotal", this.cookingTotalTime);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        CompoundTag compoundtag = new CompoundTag();
        this.recipesUsed.forEach((p_187449_, p_187450_) -> compoundtag.putInt(p_187449_.toString(), p_187450_.intValue()));
        tag.put("RecipesUsed", (Tag)compoundtag);
    }
}

