/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.block_entities.bosses;

import divinerpg.block_entities.ModUpdatableBlockEntity;
import divinerpg.entities.boss.EntityAyeraco;
import divinerpg.registries.BlockEntityRegistry;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.EntityRegistry;
import divinerpg.util.LocalizeUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class AyeracoSpawnBlockEntity
extends ModUpdatableBlockEntity {
    public int spawnTick = 600;
    private BlockPos blueBeam;
    private BlockPos greenBeam;
    private BlockPos pinkBeam;
    private BlockPos purpleBeam;
    private BlockPos redBeam;
    private BlockPos yellowBeam;

    public AyeracoSpawnBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)BlockEntityRegistry.AYERACO_SPAWN.get(), p_155229_, p_155230_);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AyeracoSpawnBlockEntity block) {
        switch (block.spawnTick) {
            case 600: {
                block.blueBeam = AyeracoSpawnBlockEntity.getBeamLocation(level, pos, 15, 0);
                block.greenBeam = AyeracoSpawnBlockEntity.getBeamLocation(level, pos, 8, 12);
                block.pinkBeam = AyeracoSpawnBlockEntity.getBeamLocation(level, pos, -8, 12);
                block.purpleBeam = AyeracoSpawnBlockEntity.getBeamLocation(level, pos, -15, 0);
                block.redBeam = AyeracoSpawnBlockEntity.getBeamLocation(level, pos, -8, -12);
                block.yellowBeam = AyeracoSpawnBlockEntity.getBeamLocation(level, pos, 8, -12);
                level.setBlock(block.blueBeam, ((Block)BlockRegistry.ayeracoBeamBlue.get()).defaultBlockState(), 3);
                AyeracoSpawnBlockEntity.logAyeracoSpawn(level, ChatFormatting.BLUE);
                break;
            }
            case 500: {
                level.setBlock(block.greenBeam, ((Block)BlockRegistry.ayeracoBeamGreen.get()).defaultBlockState(), 3);
                AyeracoSpawnBlockEntity.logAyeracoSpawn(level, ChatFormatting.GREEN);
                break;
            }
            case 400: {
                level.setBlock(block.pinkBeam, ((Block)BlockRegistry.ayeracoBeamPink.get()).defaultBlockState(), 3);
                AyeracoSpawnBlockEntity.logAyeracoSpawn(level, ChatFormatting.LIGHT_PURPLE);
                break;
            }
            case 300: {
                level.setBlock(block.purpleBeam, ((Block)BlockRegistry.ayeracoBeamPurple.get()).defaultBlockState(), 3);
                AyeracoSpawnBlockEntity.logAyeracoSpawn(level, ChatFormatting.DARK_PURPLE);
                break;
            }
            case 200: {
                level.setBlock(block.redBeam, ((Block)BlockRegistry.ayeracoBeamRed.get()).defaultBlockState(), 3);
                AyeracoSpawnBlockEntity.logAyeracoSpawn(level, ChatFormatting.RED);
                break;
            }
            case 100: {
                level.setBlock(block.yellowBeam, ((Block)BlockRegistry.ayeracoBeamYellow.get()).defaultBlockState(), 3);
                AyeracoSpawnBlockEntity.logAyeracoSpawn(level, ChatFormatting.YELLOW, "yellow");
                break;
            }
            case 0: {
                if (!level.isClientSide) {
                    byte i;
                    EntityAyeraco[] group = new EntityAyeraco[6];
                    for (i = 0; i < 6; i = (byte)(i + 1)) {
                        group[i] = ((EntityAyeraco)((EntityType)EntityRegistry.AYERACO.get()).create((ServerLevel)level, null, pos, MobSpawnType.MOB_SUMMONED, true, false)).setVariant(i);
                    }
                    group[0].setBeamPos(block.blueBeam);
                    group[1].setBeamPos(block.greenBeam);
                    group[2].setBeamPos(block.pinkBeam);
                    group[3].setBeamPos(block.purpleBeam);
                    group[4].setBeamPos(block.redBeam);
                    group[5].setBeamPos(block.yellowBeam);
                    for (i = 0; i < 6; i = (byte)(i + 1)) {
                        group[i].moveTo(pos.getX() + level.random.nextInt(5) - 2, pos.getY() + level.random.nextInt(10, 20), pos.getZ() + level.random.nextInt(5) - 2);
                        level.addFreshEntity((Entity)group[i]);
                        group[i].setVariant(i);
                    }
                }
                level.setBlock(block.worldPosition, Blocks.AIR.defaultBlockState(), 3);
                AyeracoSpawnBlockEntity.logAyeracoSpawn(level, ChatFormatting.AQUA, "spawn");
            }
        }
        if (block.spawnTick > -1) {
            --block.spawnTick;
        }
    }

    private static BlockPos getBeamLocation(Level level, BlockPos pos, int x, int z) {
        BlockPos beamCoords = pos.offset(x, 0, z);
        if (level.getBlockState(beamCoords) == Blocks.AIR.defaultBlockState()) {
            while (beamCoords.getY() > 0 && level.getBlockState(beamCoords.below()) == Blocks.AIR.defaultBlockState()) {
                beamCoords = beamCoords.below();
            }
        } else {
            while (beamCoords.getY() < 200 && level.getBlockState(beamCoords) != Blocks.AIR.defaultBlockState()) {
                beamCoords = beamCoords.above();
            }
        }
        return beamCoords;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.spawnTick = tag.getInt("spawnTick");
        if (tag.contains("blueBeam")) {
            this.blueBeam = BlockPos.of((long)tag.getLong("blueBeam"));
        }
        if (tag.contains("greenBeam")) {
            this.greenBeam = BlockPos.of((long)tag.getLong("greenBeam"));
        }
        if (tag.contains("pinkBeam")) {
            this.pinkBeam = BlockPos.of((long)tag.getLong("pinkBeam"));
        }
        if (tag.contains("purpleBeam")) {
            this.purpleBeam = BlockPos.of((long)tag.getLong("purpleBeam"));
        }
        if (tag.contains("redBeam")) {
            this.redBeam = BlockPos.of((long)tag.getLong("redBeam"));
        }
        if (tag.contains("yellowBeam")) {
            this.yellowBeam = BlockPos.of((long)tag.getLong("yellowBeam"));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("spawnTick", this.spawnTick);
        if (this.blueBeam != null) {
            tag.putLong("blueBeam", this.blueBeam.asLong());
        }
        if (this.greenBeam != null) {
            tag.putLong("greenBeam", this.greenBeam.asLong());
        }
        if (this.pinkBeam != null) {
            tag.putLong("greenBeam", this.pinkBeam.asLong());
        }
        if (this.purpleBeam != null) {
            tag.putLong("purpleBeam", this.purpleBeam.asLong());
        }
        if (this.redBeam != null) {
            tag.putLong("redBeam", this.redBeam.asLong());
        }
        if (this.yellowBeam != null) {
            tag.putLong("yellowBeam", this.yellowBeam.asLong());
        }
    }

    private static void logAyeracoSpawn(Level level, ChatFormatting formatting) {
        AyeracoSpawnBlockEntity.logAyeracoSpawn(level, formatting, null);
    }

    private static void logAyeracoSpawn(Level level, ChatFormatting formatting, String name) {
        if (level.getServer() != null) {
            if (name == null) {
                name = formatting.name().toLowerCase();
            }
            String langKey = "ayeraco." + name;
            level.getServer().getPlayerList().getPlayers().forEach(x -> {
                Component text = LocalizeUtils.clientMessage(formatting, langKey, new Object[0]);
                x.displayClientMessage(text, true);
            });
        }
    }
}

