/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.block_entities;

import divinerpg.registries.BlockEntityRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class AltarOfCorruptionBlockEntity
extends BlockEntity
implements Nameable {
    public int time;
    public float flip;
    public float oFlip;
    public float flipT;
    public float flipA;
    public float open;
    public float oOpen;
    public float rot;
    public float oRot;
    public float tRot;
    private static final RandomSource RANDOM = RandomSource.create();
    private Component name;

    public AltarOfCorruptionBlockEntity(BlockPos p_155501_, BlockState p_155502_) {
        super((BlockEntityType)BlockEntityRegistry.ALTAR_OF_CORRUPTION.get(), p_155501_, p_155502_);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.hasCustomName()) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)registries));
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("CustomName", 8)) {
            this.name = Component.Serializer.fromJson((String)tag.getString("CustomName"), (HolderLookup.Provider)registries);
        }
    }

    public static void bookAnimationTick(Level p_155504_, BlockPos p_155505_, BlockState p_155506_, AltarOfCorruptionBlockEntity p_155507_) {
        float f2;
        p_155507_.oOpen = p_155507_.open;
        p_155507_.oRot = p_155507_.rot;
        Player player = p_155504_.getNearestPlayer((double)p_155505_.getX() + 0.5, (double)p_155505_.getY() + 0.5, (double)p_155505_.getZ() + 0.5, 3.0, false);
        if (player != null) {
            double d0 = player.getX() - ((double)p_155505_.getX() + 0.5);
            double d1 = player.getZ() - ((double)p_155505_.getZ() + 0.5);
            p_155507_.tRot = (float)Mth.atan2((double)d1, (double)d0);
            p_155507_.open += 0.1f;
            if (p_155507_.open < 0.5f || RANDOM.nextInt(40) == 0) {
                float f1 = p_155507_.flipT;
                do {
                    p_155507_.flipT += (float)(RANDOM.nextInt(4) - RANDOM.nextInt(4));
                } while (f1 == p_155507_.flipT);
            }
        } else {
            p_155507_.tRot += 0.02f;
            p_155507_.open -= 0.1f;
        }
        while (p_155507_.rot >= (float)Math.PI) {
            p_155507_.rot -= (float)Math.PI * 2;
        }
        while (p_155507_.rot < (float)(-Math.PI)) {
            p_155507_.rot += (float)Math.PI * 2;
        }
        while (p_155507_.tRot >= (float)Math.PI) {
            p_155507_.tRot -= (float)Math.PI * 2;
        }
        while (p_155507_.tRot < (float)(-Math.PI)) {
            p_155507_.tRot += (float)Math.PI * 2;
        }
        for (f2 = p_155507_.tRot - p_155507_.rot; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        p_155507_.rot += f2 * 0.4f;
        p_155507_.open = Mth.clamp((float)p_155507_.open, (float)0.0f, (float)1.0f);
        ++p_155507_.time;
        p_155507_.oFlip = p_155507_.flip;
        float f = (p_155507_.flipT - p_155507_.flip) * 0.4f;
        f = Mth.clamp((float)f, (float)-0.2f, (float)0.2f);
        p_155507_.flipA += (f - p_155507_.flipA) * 0.9f;
        p_155507_.flip += p_155507_.flipA;
    }

    public Component getName() {
        return this.name != null ? this.name : Component.translatable((String)"container.enchant");
    }

    public void setCustomName(@Nullable Component p_59273_) {
        this.name = p_59273_;
    }

    @Nullable
    public Component getCustomName() {
        return this.name;
    }
}

