/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.attachments.base;

import com.mojang.serialization.Codec;
import divinerpg.attachments.base.ModAttachment;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredHolder;

public abstract class SynchedAttachement<T>
extends ModAttachment<T> {
    public final CustomPacketPayload.Type<AttachmentPayload> type;
    public final CustomPacketPayload.Type<RequestAttachmentPayload> requestType;
    public final StreamCodec<ByteBuf, AttachmentPayload> streamCodec;
    public final StreamCodec<ByteBuf, RequestAttachmentPayload> requestCodec = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, RequestAttachmentPayload::entityID, x$0 -> new RequestAttachmentPayload((int)x$0));

    public SynchedAttachement(String name, Supplier<T> defaultValue, Codec<T> codec, StreamCodec<ByteBuf, T> streamCodec) {
        super(name, defaultValue, codec);
        this.type = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)name));
        this.requestType = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)("request_" + name)));
        this.streamCodec = StreamCodec.composite(streamCodec, AttachmentPayload::data, (StreamCodec)ByteBufCodecs.INT, AttachmentPayload::entityID, (x$0, x$1) -> new AttachmentPayload(x$0, (int)x$1));
    }

    protected SynchedAttachement(String name, DeferredHolder<AttachmentType<?>, AttachmentType<T>> attachment, StreamCodec<ByteBuf, T> streamCodec) {
        super(attachment);
        this.type = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)name));
        this.requestType = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)("request_" + name)));
        this.streamCodec = StreamCodec.composite(streamCodec, AttachmentPayload::data, (StreamCodec)ByteBufCodecs.INT, AttachmentPayload::entityID, (x$0, x$1) -> new AttachmentPayload(x$0, (int)x$1));
    }

    public abstract void registerPayload(PayloadRegistrar var1);

    public abstract void requestAttachment(Entity var1, ServerPlayer var2);

    public class AttachmentPayload
    implements CustomPacketPayload {
        public final T data;
        public final int entityID;

        protected AttachmentPayload(T data, int entityID) {
            this.data = data;
            this.entityID = entityID;
        }

        public T data() {
            return this.data;
        }

        public int entityID() {
            return this.entityID;
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return SynchedAttachement.this.type;
        }
    }

    public class RequestAttachmentPayload
    implements CustomPacketPayload {
        public final int entityID;

        protected RequestAttachmentPayload(int entityID) {
            this.entityID = entityID;
        }

        public int entityID() {
            return this.entityID;
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return SynchedAttachement.this.requestType;
        }
    }
}

