/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.attachments.base;

import com.mojang.serialization.Codec;
import divinerpg.DivineRPG;
import divinerpg.attachments.base.SynchedAttachement;
import divinerpg.registries.AttachmentRegistry;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.nbt.Tag;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ServerHandledAttachment<T>
extends SynchedAttachement<T> {
    public ServerHandledAttachment(String name, Supplier<T> defaultValue, Codec<T> codec, StreamCodec<ByteBuf, T> streamCodec) {
        super(name, defaultValue, codec, streamCodec);
    }

    protected ServerHandledAttachment(String name, DeferredHolder<AttachmentType<?>, AttachmentType<T>> attachment, StreamCodec<ByteBuf, T> streamCodec) {
        super(name, attachment, streamCodec);
    }

    @Override
    public void registerPayload(PayloadRegistrar r) {
        r.playToClient(this.type, this.streamCodec, (payload, context) -> context.enqueueWork(() -> {
            Entity e = context.player().level().getEntity(payload.entityID);
            if (e != null) {
                e.setData((Supplier)this.attachment, payload.data);
            } else {
                DivineRPG.LOGGER.warn("No entity present on client with id: " + payload.entityID);
            }
        }));
        r.playToServer(this.requestType, this.requestCodec, (payload, context) -> context.enqueueWork(() -> {
            Entity e = context.player().level().getEntity(payload.entityID);
            if (e != null) {
                context.reply((CustomPacketPayload)new SynchedAttachement.AttachmentPayload(this, e.getData((Supplier)this.attachment), payload.entityID));
            }
        }));
    }

    @Override
    public void requestAttachment(Entity e, ServerPlayer player) {
        if (!e.level().isClientSide()) {
            throw new UnsupportedOperationException("Only client can send Data request!");
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new SynchedAttachement.RequestAttachmentPayload(this, e.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public boolean validate(Entity e, T data) {
        if (e.level().isClientSide()) {
            throw new UnsupportedOperationException("Server handled Data only!");
        }
        return super.validate(e, data);
    }

    @Override
    public void update(Entity e, T data) {
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)e, (CustomPacketPayload)new SynchedAttachement.AttachmentPayload(this, data, e.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static class Serializable<B extends Tag, S extends INBTSerializable<B>>
    extends ServerHandledAttachment<S> {
        public Serializable(String name, Supplier<S> defaultValue, StreamCodec<ByteBuf, S> streamCodec) {
            super(name, AttachmentRegistry.ATTACHMENT_TYPES.register(name, () -> AttachmentType.serializable((Supplier)defaultValue).build()), streamCodec);
        }
    }
}

