/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.attachments.base;

import com.mojang.serialization.Codec;
import divinerpg.registries.AttachmentRegistry;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.registries.DeferredHolder;

public abstract class ModAttachment<T> {
    public final DeferredHolder<AttachmentType<?>, AttachmentType<T>> attachment;

    public ModAttachment(DeferredHolder<AttachmentType<?>, AttachmentType<T>> attachment) {
        this.attachment = attachment;
    }

    public ModAttachment(String name, Supplier<T> defaultValue, Codec<T> codec) {
        this.attachment = AttachmentRegistry.ATTACHMENT_TYPES.register(name, () -> AttachmentType.builder((Supplier)defaultValue).serialize(codec).build());
    }

    public abstract void update(Entity var1, T var2);

    public boolean validate(Entity e, T data) {
        return !e.getData(this.attachment).equals(data);
    }

    public void set(Entity e, T data) {
        if (this.validate(e, data)) {
            e.setData(this.attachment, data);
            this.update(e, data);
        }
    }

    public void setSilent(Entity e, T data) {
        if (this.validate(e, data)) {
            e.setData(this.attachment, data);
        }
    }

    public T get(Entity e) {
        return (T)e.getData(this.attachment);
    }

    public T getOrDefault(Entity e, T defaultValue) {
        return (T)(e.hasData(this.attachment) ? e.getData(this.attachment) : defaultValue);
    }

    public boolean has(Entity e) {
        return e.hasData(this.attachment);
    }

    public void clone(Entity original, Entity clone) {
        if (original.hasData(this.attachment)) {
            this.set(clone, original.getData(this.attachment));
        }
    }
}

