/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.attachments;

import divinerpg.registries.AttachmentRegistry;
import divinerpg.registries.MobEffectRegistry;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class Arcana {
    public static boolean hasArcana(@Nullable LivingEntity entity) {
        return entity != null && AttachmentRegistry.ARCANA.has((Entity)entity);
    }

    public static float getAmount(@Nullable LivingEntity entity) {
        if (entity == null) {
            return 0.0f;
        }
        return (!AttachmentRegistry.ARCANA.has((Entity)entity) && entity instanceof Player ? (Float)AttachmentRegistry.MAX_ARCANA.get((Entity)entity) : (Float)AttachmentRegistry.ARCANA.get((Entity)entity)).floatValue();
    }

    public static float getMaxArcana(@Nullable LivingEntity entity) {
        return entity == null ? 0.0f : ((Float)AttachmentRegistry.MAX_ARCANA.get((Entity)entity)).floatValue();
    }

    public static int getRegenDelay() {
        return 4;
    }

    public static void setAmount(@Nullable LivingEntity entity, float amount) {
        if (entity == null) {
            return;
        }
        Arcana.setAmount(entity, amount, Arcana.getAmount(entity));
    }

    private static void setAmount(@Nullable LivingEntity entity, float amount, float previous) {
        if (previous != (amount = Math.clamp(amount, 0.0f, Arcana.getMaxArcana(entity)))) {
            AttachmentRegistry.ARCANA.set((Entity)entity, Float.valueOf(amount));
        }
    }

    public static void modifyAmount(@Nullable LivingEntity entity, float amount) {
        Player player;
        if (!(amount == 0.0f || !(amount > 0.0f) && entity instanceof Player && (player = (Player)entity).isCreative())) {
            float previous = Arcana.getAmount(entity);
            Arcana.setAmount(entity, previous + amount, previous);
        }
    }

    public static void regen(@Nullable LivingEntity entity) {
        if (entity != null && entity.level().getGameTime() % (long)Arcana.getRegenDelay() == 0L) {
            Arcana.modifyAmount(entity, entity.hasEffect(MobEffectRegistry.KORMA_ARCANA) ? 4.0f : 1.0f);
        }
    }

    public static void setMaxArcana(@Nullable LivingEntity entity, float max) {
        if (entity == null) {
            return;
        }
        max = Math.max(max, 0.0f);
        if (Arcana.getMaxArcana(entity) != max) {
            AttachmentRegistry.MAX_ARCANA.set((Entity)entity, Float.valueOf(max));
        }
    }
}

