/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.NavigationData;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;

public class NavigationCommand
extends Command {
    private static final String ARG_POSITION = "position";

    private NavigationCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"navigation").requires(cs -> cs.hasPermission(0))).then(((LiteralArgumentBuilder)Commands.literal((String)"set").then(((LiteralArgumentBuilder)Commands.literal((String)"home").requires(commandSourceStack -> commandSourceStack.hasPermission(0))).then(Commands.argument((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(Commands.argument((String)ARG_POSITION, (ArgumentType)Vec3Argument.vec3()).executes(context -> {
            Coordinates coordinates = Vec3Argument.getCoordinates((CommandContext)context, (String)ARG_POSITION);
            return NavigationCommand.setHomePosition((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), coordinates.getPosition((CommandSourceStack)context.getSource()));
        }))))).then(((LiteralArgumentBuilder)Commands.literal((String)"pos").requires(commandSourceStack -> commandSourceStack.hasPermission(0))).then(Commands.argument((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(Commands.argument((String)ARG_POSITION, (ArgumentType)Vec3Argument.vec3()).executes(context -> {
            Coordinates coordinates = Vec3Argument.getCoordinates((CommandContext)context, (String)ARG_POSITION);
            return NavigationCommand.setPosition((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), coordinates.getPosition((CommandSourceStack)context.getSource()));
        })))))).then(((LiteralArgumentBuilder)Commands.literal((String)"reset").requires(commandSourceStack -> commandSourceStack.hasPermission(0))).then(Commands.argument((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).executes(context -> NavigationCommand.reset((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target")))));
    }

    private static int setHomePosition(CommandSourceStack context, EasyNPC<?> easyNPC, Vec3 position) {
        if (easyNPC == null || position == null || position.equals((Object)Vec3.ZERO)) {
            return 0;
        }
        NavigationData<?> navigationData = easyNPC.getEasyNPCNavigationData();
        if (navigationData == null) {
            return NavigationCommand.sendFailureMessageNoNavigationData(context, easyNPC);
        }
        BlockPos blockPos = new BlockPos((int)position.x, (int)position.y, (int)position.z);
        navigationData.setHomePosition(blockPos);
        return NavigationCommand.sendSuccessMessage(context, "Set home position for EasyNPC " + String.valueOf(easyNPC) + " with UUID " + String.valueOf(easyNPC.getUUID()) + " to " + String.valueOf(blockPos));
    }

    private static int setPosition(CommandSourceStack context, EasyNPC<?> easyNPC, Vec3 position) {
        if (easyNPC == null || position == null || position.equals((Object)Vec3.ZERO)) {
            return 0;
        }
        NavigationData<?> navigationData = easyNPC.getEasyNPCNavigationData();
        if (navigationData == null) {
            return NavigationCommand.sendFailureMessageNoNavigationData(context, easyNPC);
        }
        navigationData.setPosition(position);
        return NavigationCommand.sendSuccessMessage(context, "Set position for EasyNPC " + String.valueOf(easyNPC) + " with UUID " + String.valueOf(easyNPC.getUUID()) + " to " + String.valueOf(position));
    }

    private static int reset(CommandSourceStack context, EasyNPC<?> easyNPC) {
        if (easyNPC == null) {
            return 0;
        }
        NavigationData<?> navigationData = easyNPC.getEasyNPCNavigationData();
        if (navigationData == null) {
            return NavigationCommand.sendFailureMessageNoNavigationData(context, easyNPC);
        }
        navigationData.getGroundPathNavigation().recomputePath();
        return NavigationCommand.sendSuccessMessage(context, "Reset navigation for EasyNPC " + String.valueOf(easyNPC));
    }
}

