/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record RemoveNPCMessage(UUID uuid) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"remove_npc");
    public static final CustomPacketPayload.Type<RemoveNPCMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, RemoveNPCMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), RemoveNPCMessage::create);

    public static RemoveNPCMessage create(FriendlyByteBuf buffer) {
        return new RemoveNPCMessage(buffer.readUUID());
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
    }

    @Override
    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    @Override
    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        log.info("Removing Easy NPC {} requested by {}", easyNPC, (Object)serverPlayer);
        easyNPC.getEntity().discard();
    }
}

